/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.ConsentAbstract;
import org.nakedobjects.plugins.dnd.MenuOptions;
import org.nakedobjects.plugins.dnd.UserAction;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dnd.viewer.debug.DebugDumpSnapshotOption;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;

public class LoggingOptions
implements MenuOptions {
    public void menuOptions(UserActionSet options) {
        options.add(this.loggingOption("Off", Level.OFF));
        options.add(this.loggingOption("Error", Level.ERROR));
        options.add(this.loggingOption("Warn", Level.WARN));
        options.add(this.loggingOption("Info", Level.INFO));
        options.add(this.loggingOption("Debug", Level.DEBUG));
        options.add(new DebugDumpSnapshotOption());
    }

    private AbstractUserAction loggingOption(String name, final Level level) {
        return new AbstractUserAction("Log level " + level, UserAction.DEBUG){

            public Consent disabled(View component) {
                return ConsentAbstract.allowIf((LogManager.getRootLogger().getLevel() != level ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                LogManager.getRootLogger().setLevel(level);
            }
        };
    }
}

