/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.nakedobjects.plugins.dnd.InteractionSpyWindow;

class SpyWindow
implements InteractionSpyWindow {
    private int event;
    private String[][] label = new String[2][20];
    private String[] trace = new String[60];
    private int traceIndex;
    private SpyFrame frame;

    SpyWindow() {
    }

    public void display(int event, String[][] label, String[] trace, int traceIndex) {
        if (this.frame != null) {
            this.event = event;
            this.traceIndex = traceIndex;
            this.label = label;
            this.trace = trace;
            this.frame.repaint();
        }
    }

    public void open() {
        this.frame = new SpyFrame();
        this.frame.setBounds(10, 10, 800, 500);
        this.frame.setVisible(true);
    }

    public void close() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    class SpyFrame
    extends Frame {
        private static final long serialVersionUID = 1L;

        public SpyFrame() {
            super("View/Interaction Spy");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    SpyWindow.this.close();
                }
            });
        }

        public void paint(Graphics g) {
            int i;
            int baseline = this.getInsets().top + 15;
            g.drawString("Event " + SpyWindow.this.event, 10, baseline);
            baseline += 18;
            for (i = 0; i < SpyWindow.this.label[0].length; ++i) {
                if (SpyWindow.this.label[0][i] != null) {
                    g.drawString(SpyWindow.this.label[0][i], 10, baseline);
                    g.drawString(SpyWindow.this.label[1][i], 150, baseline);
                }
                baseline += 12;
            }
            baseline += 6;
            for (i = 0; i < SpyWindow.this.traceIndex; ++i) {
                if (SpyWindow.this.trace[i] != null) {
                    g.drawString(SpyWindow.this.trace[i], 10, baseline);
                }
                baseline += 12;
            }
        }
    }
}

