/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nakedobjects.metamodel.commons.about.AboutNakedObjects;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.viewer.AWTUtilities;
import org.nakedobjects.plugins.dnd.viewer.AwtColor;
import org.nakedobjects.plugins.dnd.viewer.RenderingArea;
import org.nakedobjects.plugins.dnd.viewer.ShutdownDialog;
import org.nakedobjects.plugins.dnd.viewer.XViewer;

public class ViewerFrame
extends Frame
implements RenderingArea {
    private static final String DEFAULT_TITLE = "Naked Objects";
    private static final long serialVersionUID = 1L;
    private XViewer viewer;

    public ViewerFrame() {
        this.setBackground(((AwtColor)Toolkit.getColor("color.background.application")).getAwtColor());
        AWTUtilities.addWindowIcon(this, "application-logo.png");
        this.setTitle(null);
        try {
            Class<?> c = this.getClass();
            Method m = c.getMethod("setFocusTraversalKeysEnabled", Boolean.TYPE);
            m.invoke((Object)this, Boolean.FALSE);
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        this.repaint();
        return true;
    }

    public final void paint(Graphics g) {
        this.update(g);
    }

    public void quit() {
        this.viewer.quit();
    }

    public void update(Graphics g) {
        this.viewer.paint(g);
    }

    public void setViewer(XViewer viewer) {
        this.viewer = viewer;
    }

    public void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                new ShutdownDialog(ViewerFrame.this);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ViewerFrame.this.viewer.sizeChange();
            }
        });
    }

    public void set_Viewer(XViewer viewer) {
        this.setViewer(viewer);
    }

    public void set_Title(String title) {
        this.setTitle(title);
    }

    public void setTitle(String title) {
        String application = AboutNakedObjects.getApplicationName();
        String str = title == null ? (application == null ? DEFAULT_TITLE : application) : title;
        super.setTitle(str);
    }

    public String selectFilePath(String title, String directory) {
        FileDialog dlg = new FileDialog((Frame)this, title);
        dlg.setVisible(true);
        String path = dlg.getDirectory() + dlg.getFile();
        return path;
    }
}

