/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.action;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.viewer.action.ButtonRender;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;

public class Button3DStyleRender
implements ButtonRender {
    private static final int TEXT_PADDING = 12;
    private static final Text style = Toolkit.getText("text.control");
    private final int buttonHeight = 4 + style.getTextHeight() + 4;

    public void draw(Canvas canvas, Size size, boolean isDisabled, boolean isDefault, boolean hasFocus, boolean isOver, boolean isPressed, String text) {
        boolean x = false;
        boolean y = false;
        int buttonWidth = 12 + style.stringWidth(text) + 12;
        canvas.drawSolidRectangle(0, 0, buttonWidth, this.buttonHeight, Toolkit.getColor("color.secondary3"));
        Color color = isDisabled ? Toolkit.getColor("color.menu.disabled") : Toolkit.getColor("color.black");
        Color border = isDisabled ? Toolkit.getColor("color.secondary3") : Toolkit.getColor("color.secondary2");
        canvas.drawRectangle(0, 0, buttonWidth, this.buttonHeight, isOver & !isDisabled ? Toolkit.getColor("color.primary1") : Toolkit.getColor("color.black"));
        canvas.draw3DRectangle(1, 1, buttonWidth - 2, this.buttonHeight - 2, border, !isPressed);
        canvas.draw3DRectangle(2, 2, buttonWidth - 4, this.buttonHeight - 4, border, !isPressed);
        if (isDefault) {
            canvas.drawRectangle(3, 3, buttonWidth - 6, this.buttonHeight - 6, border);
        }
        if (hasFocus) {
            canvas.drawRectangle(3, 3, buttonWidth - 6, this.buttonHeight - 6, Toolkit.getColor("color.white"));
        }
        canvas.drawText(text, 12, 0 + this.buttonHeight / 2 + style.getMidPoint(), color, style);
    }

    public Size getMaximumSize(String text) {
        int buttonWidth = 12 + Toolkit.getText("text.control").stringWidth(text) + 12;
        return new Size(buttonWidth, this.buttonHeight);
    }
}

