/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.action;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.viewer.action.ButtonRender;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;

public class ButtonLineStyleRender
implements ButtonRender {
    private static final int TEXT_PADDING = 12;
    private static final Text style = Toolkit.getText("text.control");
    private final int buttonHeight = 2 + style.getTextHeight() + 2;

    public void draw(Canvas canvas, Size size, boolean isDisabled, boolean isDefault, boolean hasFocus, boolean isOver, boolean isPressed, String text) {
        int buttonWidth = 12 + style.stringWidth(text) + 12;
        Color textColor = Toolkit.getColor("color.black");
        Color borderColor = isDisabled ? (textColor = Toolkit.getColor("color.menu.disabled")) : (isDefault ? Toolkit.getColor("color.primary1") : (isOver || hasFocus ? Toolkit.getColor("color.black") : Toolkit.getColor("color.black")));
        canvas.drawRoundedRectangle(0, 0, buttonWidth, this.buttonHeight, 0, 0, borderColor);
        canvas.drawText(text, 12, this.buttonHeight / 2 + style.getMidPoint(), textColor, style);
    }

    public Size getMaximumSize(String text) {
        int buttonWidth = 12 + Toolkit.getText("text.control").stringWidth(text) + 12;
        return new Size(buttonWidth, this.buttonHeight);
    }
}

