/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.basic;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAreaType;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewRequirement;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.view.simple.ObjectView;

public class FallbackView
extends ObjectView {
    protected FallbackView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Size size = this.getSize();
        int width = size.getWidth() - 1;
        int height = size.getHeight() - 1;
        canvas.drawSolidRectangle(0, 0, width, height, Toolkit.getColor("color.secondary3"));
        canvas.drawSolidRectangle(0, 0, 10, height, Toolkit.getColor("color.secondary2"));
        canvas.drawLine(10, 0, 10, height - 2, Toolkit.getColor("color.black"));
        canvas.drawRectangle(0, 0, width, height, Toolkit.getColor("color.black"));
        canvas.drawText(this.getContent().title(), 14, this.getBaseline(), Toolkit.getColor("color.black"), Toolkit.getText("text.normal"));
    }

    public int getBaseline() {
        return 14;
    }

    public Size getMaximumSize() {
        return new Size(150, 20);
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return mouseLocation.getX() <= 10 ? ViewAreaType.VIEW : ViewAreaType.CONTENT;
    }

    public static class Specification
    implements ViewSpecification {
        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return true;
        }

        public View createView(Content content, ViewAxis axis) {
            return new FallbackView(content, this, axis);
        }

        public String getName() {
            return "Fallback";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }
}

