/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.basic;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.ContentDrag;
import org.nakedobjects.plugins.dnd.Drag;
import org.nakedobjects.plugins.dnd.DragStart;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.UserAction;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAreaType;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewRequirement;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.ViewState;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dnd.viewer.action.WindowControl;
import org.nakedobjects.plugins.dnd.viewer.basic.SubviewIconSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Padding;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;

public class MinimizedView
extends AbstractView {
    private static final int BORDER_WIDTH = 5;
    private final WindowControl[] controls;
    private View iconView;
    private final View minimizedView;

    public MinimizedView(View viewToMinimize) {
        super(viewToMinimize.getContent(), new Specification(), null);
        this.minimizedView = viewToMinimize;
        this.iconView = new SubviewIconSpecification().createView(viewToMinimize.getContent(), null);
        this.iconView.setParent(this);
        this.controls = new WindowControl[]{new RestoreWindowControl((View)this), new CloseWindowControl((View)this)};
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        debug.appendln("minimized view", (Object)this.minimizedView);
        debug.appendln();
        debug.appendln("icon size", (Object)this.iconView.getSize());
        debug.append((Object)this.iconView);
    }

    public void dispose() {
        super.dispose();
        this.iconView.dispose();
    }

    public Drag dragStart(DragStart drag) {
        if (this.iconView.getBounds().contains(drag.getLocation())) {
            drag.subtract(5, 5);
            return this.iconView.dragStart(drag);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Size size = this.getSize();
        int width = size.getWidth();
        int height = size.getHeight();
        int left = 3;
        int top = 3;
        boolean hasFocus = this.containsFocus();
        Color lightColor = hasFocus ? Toolkit.getColor("color.secondary1") : Toolkit.getColor("color.secondary2");
        canvas.clearBackground(this, Toolkit.getColor("color.background.window"));
        canvas.drawRectangle(1, 0, width - 2, height, lightColor);
        canvas.drawRectangle(0, 1, width, height - 2, lightColor);
        for (int i = 2; i < 3; ++i) {
            canvas.drawRectangle(i, i, width - 2 * i, height - 2 * i, lightColor);
        }
        ViewState state = this.getState();
        if (state.isActive()) {
            int i = 3;
            canvas.drawRectangle(3, 3, width - 6, height - 6 - 3, Toolkit.getColor("color.active"));
        }
        int bw = this.controls[0].getLocation().getX() - 3;
        canvas.drawSolidRectangle(bw, 3, width - bw - 3, height - 6, Toolkit.getColor("color.secondary3"));
        canvas.drawLine(bw - 1, 3, bw - 1, height - 6, lightColor);
        for (int i = 0; this.controls != null && i < this.controls.length; ++i) {
            Canvas controlCanvas = canvas.createSubcanvas(this.controls[i].getBounds());
            this.controls[i].draw(controlCanvas);
        }
        Canvas c = canvas.createSubcanvas(this.iconView.getBounds());
        this.iconView.draw(c);
    }

    public Size getMaximumSize() {
        Size size = new Size();
        size.extendWidth(5);
        Size iconMaximumSize = this.iconView.getMaximumSize();
        size.extendWidth(iconMaximumSize.getWidth());
        size.extendHeight(iconMaximumSize.getHeight());
        size.ensureHeight(13);
        size.extendHeight(5);
        size.extendHeight(5);
        size.extendWidth(HPADDING);
        size.extendWidth(this.controls.length * (15 + HPADDING));
        size.extendWidth(5);
        return size;
    }

    public Padding getPadding() {
        return new Padding(5, 5, 5, 5);
    }

    public void layout(Size maximumSize) {
        Size size = this.getMaximumSize();
        this.layoutControls(size.getWidth());
        size.contractWidth(10);
        size.contractWidth(HPADDING);
        size.contractWidth(this.controls.length * (15 + HPADDING));
        size.contractHeight(10);
        this.iconView.setLocation(new Location(5, 5));
        this.iconView.setSize(size);
    }

    private void layoutControls(int width) {
        int widthControl = 15 + HPADDING;
        int x = width - 5 + HPADDING;
        x -= widthControl * this.controls.length;
        int y = 5;
        for (int i = 0; i < this.controls.length; ++i) {
            this.controls[i].setSize(this.controls[i].getMaximumSize());
            this.controls[i].setLocation(new Location(x, 5));
            x += widthControl;
        }
    }

    private void restore() {
        Workspace workspace = this.getWorkspace();
        View[] views = workspace.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            if (views[i] != this) continue;
            this.dispose();
            this.minimizedView.setParent(workspace);
            workspace.addView(this.minimizedView);
            workspace.invalidateLayout();
            return;
        }
    }

    private void close() {
        Workspace workspace = this.getWorkspace();
        View[] views = workspace.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            if (views[i] != this) continue;
            this.dispose();
            this.minimizedView.setParent(workspace);
            workspace.invalidateLayout();
            workspace.addView(this.minimizedView);
            this.minimizedView.dispose();
            return;
        }
    }

    public void removeView(View view) {
        if (view != this.iconView) {
            throw new NakedObjectException("No view " + view + " in " + this);
        }
        this.iconView = null;
    }

    public void secondClick(Click click) {
        this.restore();
    }

    public ViewAreaType viewAreaType(Location location) {
        location.subtract(5, 5);
        return this.iconView.viewAreaType(location);
    }

    public void viewMenuOptions(UserActionSet options) {
        options.add(new AbstractUserAction("Restore"){

            public void execute(Workspace workspace, View view, Location at) {
                MinimizedView.this.restore();
            }
        });
        super.viewMenuOptions(options);
    }

    public void firstClick(Click click) {
        View button = this.overControl(click.getLocation());
        if (button != null) {
            button.firstClick(click);
        }
    }

    private View overControl(Location location) {
        for (int i = 0; i < this.controls.length; ++i) {
            WindowControl control = this.controls[i];
            if (!control.getBounds().contains(location)) continue;
            return control;
        }
        return null;
    }

    public void dragIn(ContentDrag drag) {
        if (this.iconView.getBounds().contains(drag.getTargetLocation())) {
            drag.subtract(5, 5);
            this.iconView.dragIn(drag);
        }
    }

    public void dragOut(ContentDrag drag) {
        if (this.iconView.getBounds().contains(drag.getTargetLocation())) {
            drag.subtract(5, 5);
            this.iconView.dragOut(drag);
        }
    }

    public View identify(Location location) {
        if (this.iconView.getBounds().contains(location)) {
            location.subtract(5, 5);
            return this.iconView.identify(location);
        }
        return this;
    }

    public void drop(ContentDrag drag) {
        if (this.iconView.getBounds().contains(drag.getTargetLocation())) {
            drag.subtract(5, 5);
            this.iconView.drop(drag);
        }
    }

    private static class Specification
    implements ViewSpecification {
        private Specification() {
        }

        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return false;
        }

        public View createView(Content content, ViewAxis axis) {
            return null;
        }

        public String getName() {
            return "minimized view";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }

    private class RestoreWindowControl
    extends WindowControl {
        public RestoreWindowControl(View target) {
            super(new UserAction(){

                public Consent disabled(View view) {
                    return Allow.DEFAULT;
                }

                public void execute(Workspace workspace, View view, Location at) {
                    ((MinimizedView)view).restore();
                }

                public String getDescription(View view) {
                    return "Restore " + view.getSpecification().getName() + " to normal size";
                }

                public String getHelp(View view) {
                    return null;
                }

                public String getName(View view) {
                    return "Restore view";
                }

                public NakedObjectActionType getType() {
                    return USER;
                }
            }, target);
        }

        public void draw(Canvas canvas) {
            boolean x = false;
            boolean y = false;
            Color black = Toolkit.getColor("color.black");
            canvas.drawRectangle(1, 1, 14, 12, black);
            canvas.drawLine(2, 2, 13, 2, black);
            canvas.drawLine(2, 3, 13, 3, black);
        }
    }

    private class CloseWindowControl
    extends WindowControl {
        public CloseWindowControl(View target) {
            super(new UserAction(){

                public Consent disabled(View view) {
                    return Allow.DEFAULT;
                }

                public void execute(Workspace workspace, View view, Location at) {
                    ((MinimizedView)view).close();
                }

                public String getDescription(View view) {
                    return "Close " + view.getSpecification().getName();
                }

                public String getHelp(View view) {
                    return null;
                }

                public String getName(View view) {
                    return "Close view";
                }

                public NakedObjectActionType getType() {
                    return USER;
                }
            }, target);
        }

        public void draw(Canvas canvas) {
            boolean x = false;
            boolean y = false;
            Color crossColor = Toolkit.getColor("color.black");
            canvas.drawLine(4, 3, 10, 9, crossColor);
            canvas.drawLine(5, 3, 11, 9, crossColor);
            canvas.drawLine(10, 3, 4, 9, crossColor);
            canvas.drawLine(11, 3, 5, 9, crossColor);
        }
    }
}

