/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.basic;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.NullContent;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;

public class ViewResizeOutline
extends AbstractView {
    private final int thickness = 1;
    private String label = "";
    private final Size size;

    protected ViewResizeOutline(Bounds resizeArea) {
        super(new NullContent());
        this.size = resizeArea.getSize();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Size s = this.getSize();
        Color color = Toolkit.getColor("color.primary2");
        for (int i = 0; i < 1; ++i) {
            canvas.drawRectangle(i, i, s.getWidth() - i * 2 - 1, s.getHeight() - i * 2 - 1, color);
        }
        canvas.drawText(this.label, 2, 16, color, Toolkit.getText("text.normal"));
    }

    public void setDisplay(String label) {
        this.label = label == null ? "" : label;
    }

    public void dispose() {
        this.getFeedbackManager().showDefaultCursor();
        super.dispose();
    }

    public Size getMaximumSize() {
        return new Size(this.size);
    }
}

