/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Drag;
import org.nakedobjects.plugins.dnd.DragStart;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewDrag;
import org.nakedobjects.plugins.dnd.ViewState;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.action.WindowControl;
import org.nakedobjects.plugins.dnd.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dnd.viewer.border.BorderDrawing;
import org.nakedobjects.plugins.dnd.viewer.border.SwingStyleWindowBorder;
import org.nakedobjects.plugins.dnd.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Offset;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;

public abstract class AbstractWindowBorder
extends AbstractBorder {
    protected BorderDrawing borderRender = new SwingStyleWindowBorder();
    protected WindowControl[] controls;
    private WindowControl overControl;

    public AbstractWindowBorder(View enclosedView) {
        super(enclosedView);
        this.left = this.borderRender.getLeft();
        this.right = this.borderRender.getRight();
        this.top = this.borderRender.getTop();
        this.bottom = this.borderRender.getBottom();
    }

    public void debugDetails(DebugString debug) {
        super.debugDetails(debug);
        this.borderRender.debugDetails(debug);
        if (this.controls.length > 0) {
            debug.appendln("controls:-");
            debug.indent();
            for (WindowControl control : this.controls) {
                debug.append((Object)control);
                debug.appendln();
            }
            debug.unindent();
        }
    }

    public Drag dragStart(DragStart drag) {
        if (this.overBorder(drag.getLocation())) {
            Location location = drag.getLocation();
            View dragOverlay = Toolkit.getViewFactory().createDragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(location.getX(), location.getY()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    protected void setControls(WindowControl[] controls) {
        this.controls = controls;
    }

    public void setSize(Size size) {
        super.setSize(size);
        this.layoutControls(size);
    }

    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        this.layoutControls(bounds.getSize());
    }

    private void layoutControls(Size size) {
        this.borderRender.layoutControls(size, this.controls);
    }

    public void draw(Canvas canvas) {
        Bounds bounds = this.getBounds();
        Color color = Toolkit.getColor("color.background.window." + this.getSpecification().getName());
        canvas.drawSolidRectangle(1, 1, bounds.getWidth() - 2, bounds.getHeight() - 2, color);
        boolean hasFocus = this.containsFocus();
        ViewState state = this.getState();
        this.borderRender.draw(canvas, this.getSize(), hasFocus, state, this.controls, this.title());
        for (int i = 0; this.controls != null && i < this.controls.length; ++i) {
            Canvas controlCanvas = canvas.createSubcanvas(this.controls[i].getBounds());
            this.controls[i].draw(controlCanvas);
        }
        super.draw(canvas);
    }

    protected abstract String title();

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        this.borderRender.getRequiredSize(size, this.title(), this.controls);
        return size;
    }

    public void secondClick(Click click) {
        View control = this.overControl(click.getLocation());
        if (control == null) {
            super.secondClick(click);
        }
    }

    public void thirdClick(Click click) {
        View control = this.overControl(click.getLocation());
        if (control == null) {
            super.thirdClick(click);
        }
    }

    public void firstClick(Click click) {
        View control = this.overControl(click.getLocation());
        if (control == null) {
            if (this.overBorder(click.getLocation())) {
                Workspace workspace = this.getWorkspace();
                if (workspace != null) {
                    if (click.button2()) {
                        workspace.lower(this.getView());
                    } else if (click.button1()) {
                        workspace.raise(this.getView());
                    }
                }
            } else {
                super.firstClick(click);
            }
        } else {
            control.firstClick(click);
        }
    }

    public void mouseMoved(Location at) {
        WindowControl control = (WindowControl)this.overControl(at);
        if (control != null) {
            if (control != this.overControl) {
                control.entered();
                this.overControl = control;
                return;
            }
        } else if (control != this.overControl) {
            this.overControl.exited();
            this.overControl = null;
            return;
        }
        super.mouseMoved(at);
    }

    private View overControl(Location location) {
        for (int i = 0; i < this.controls.length; ++i) {
            WindowControl control = this.controls[i];
            if (!control.getBounds().contains(location)) continue;
            return control;
        }
        return null;
    }
}

