/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.border;

public class ScrollBar {
    private int maximum;
    private int minimum;
    private int scrollPosition = 0;
    private int visibleAmount;

    public void setPostion(int position) {
        this.scrollPosition = Math.min(position, this.maximum);
        this.scrollPosition = Math.max(this.scrollPosition, this.minimum);
    }

    public void firstClick(int x, boolean alt) {
        if (alt) {
            this.setPostion(x - this.visibleAmount / 2);
        } else if (x < this.scrollPosition) {
            this.setPostion(this.scrollPosition - this.visibleAmount);
        } else if (x > this.scrollPosition + this.visibleAmount) {
            this.setPostion(this.scrollPosition + this.visibleAmount);
        }
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getPosition() {
        return this.scrollPosition;
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public void limit() {
        if (this.scrollPosition > this.maximum) {
            this.scrollPosition = this.maximum;
        }
    }

    public void reset() {
        this.scrollPosition = 0;
    }

    public boolean isOnThumb(int pos) {
        return pos > this.scrollPosition && pos < this.scrollPosition + this.visibleAmount;
    }

    public void setSize(int viewportSize, int contentSize) {
        this.visibleAmount = contentSize == 0 ? 0 : viewportSize * viewportSize / contentSize;
        this.maximum = viewportSize - this.visibleAmount;
    }

    public void secondClick(int y) {
        int midpoint = (this.maximum + this.visibleAmount) / 2;
        this.setPostion(y < midpoint ? this.minimum : this.maximum);
    }
}

