/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.builder;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.plugins.dnd.CollectionContent;
import org.nakedobjects.plugins.dnd.CompositeViewSpecification;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.OneToManyField;
import org.nakedobjects.plugins.dnd.SubviewSpec;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.viewer.builder.AbstractViewBuilder;
import org.nakedobjects.plugins.dnd.viewer.content.AbstractObjectContent;
import org.nakedobjects.plugins.dnd.viewer.content.CollectionElement;
import org.nakedobjects.plugins.dnd.viewer.content.OneToManyFieldElementImpl;
import org.nakedobjects.plugins.dnd.viewer.view.simple.CompositeViewUsingBuilder;

public class CollectionElementBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(CollectionElementBuilder.class);
    private boolean canDragView = true;
    private final SubviewSpec subviewDesign;

    public CollectionElementBuilder(SubviewSpec subviewDesign) {
        this.subviewDesign = subviewDesign;
    }

    public void build(View view) {
        Assert.assertEquals((Object)view.getView(), (Object)view);
        Content content = view.getContent();
        OneToManyAssociation field = content instanceof OneToManyField ? ((OneToManyField)content).getOneToManyAssociation() : null;
        LOG.debug((Object)("rebuild view " + view + " for " + content));
        CollectionContent collectionContent = (CollectionContent)((Object)content);
        Enumeration elements = collectionContent.allElements();
        View[] subviews = view.getSubviews();
        NakedObject[] existingElements = new NakedObject[subviews.length];
        for (int i = 0; i < subviews.length; ++i) {
            view.removeView(subviews[i]);
            existingElements[i] = subviews[i].getContent().getNaked();
        }
        int fieldNumber = 0;
        while (elements.hasMoreElements()) {
            NakedObject element = (NakedObject)elements.nextElement();
            View elementView = null;
            for (int i = 0; i < subviews.length; ++i) {
                if (existingElements[i] != element) continue;
                elementView = subviews[i];
                existingElements[i] = null;
                break;
            }
            if (elementView == null) {
                AbstractObjectContent elementContent;
                if (field == null) {
                    elementContent = new CollectionElement(element);
                } else {
                    NakedObject obj;
                    NakedObject parent = obj = ((OneToManyField)view.getContent()).getParent();
                    elementContent = new OneToManyFieldElementImpl(parent, element, field);
                }
                elementView = this.subviewDesign.createSubview(elementContent, view.getViewAxis(), fieldNumber++);
            }
            if (elementView == null) continue;
            view.addView(this.decorateSubview(elementView));
        }
    }

    public View decorateSubview(View subview) {
        return this.subviewDesign.decorateSubview(subview);
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        CompositeViewUsingBuilder view = new CompositeViewUsingBuilder(content, specification, axis);
        view.setCanDragView(this.canDragView);
        return view;
    }

    public void setCanDragView(boolean canDragView) {
        this.canDragView = canDragView;
    }
}

