/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.builder;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.metamodel.util.NakedObjectUtils;
import org.nakedobjects.plugins.dnd.CompositeViewSpecification;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.FieldContent;
import org.nakedobjects.plugins.dnd.ObjectContent;
import org.nakedobjects.plugins.dnd.SubviewSpec;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.viewer.builder.AbstractViewBuilder;
import org.nakedobjects.plugins.dnd.viewer.view.simple.CompositeViewUsingBuilder;
import org.nakedobjects.plugins.dnd.viewer.view.simple.FieldErrorView;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class ObjectFieldBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(ObjectFieldBuilder.class);
    private final SubviewSpec subviewDesign;

    public ObjectFieldBuilder(SubviewSpec subviewDesign) {
        this.subviewDesign = subviewDesign;
    }

    public void build(View view) {
        Assert.assertEquals((String)"ensure the view is the complete decorated view", (Object)view.getView(), (Object)view);
        Content content = view.getContent();
        NakedObject object = ((ObjectContent)content).getObject();
        LOG.debug((Object)("build view " + view + " for " + object));
        NakedObjectSpecification spec = object.getSpecification();
        Filter filter = NakedObjectAssociationFilters.dynamicallyVisible((AuthenticationSession)NakedObjectsContext.getAuthenticationSession(), (NakedObject)object);
        NakedObjectAssociation[] flds = spec.getAssociations(filter);
        if (view.getSubviews().length == 0) {
            this.newBuild(view, object, flds);
        } else {
            this.updateBuild(view, object, flds);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        return new CompositeViewUsingBuilder(content, specification, axis);
    }

    public View decorateSubview(View subview) {
        return this.subviewDesign.decorateSubview(subview);
    }

    private void newBuild(View view, NakedObject object, NakedObjectAssociation[] flds) {
        LOG.debug((Object)"  as new build");
        for (int f = 0; f < flds.length; ++f) {
            NakedObjectAssociation field = flds[f];
            this.addField(view, object, field, f);
        }
    }

    private void addField(View view, NakedObject object, NakedObjectAssociation field, int fieldNumber) {
        View fieldView = this.createFieldView(view, object, fieldNumber, field);
        if (fieldView != null) {
            view.addView(this.decorateSubview(fieldView));
        }
    }

    private void updateBuild(View view, NakedObject object, NakedObjectAssociation[] flds) {
        int i;
        LOG.debug((Object)"  as update build");
        View[] subviews = view.getSubviews();
        block0: for (i = 0; i < subviews.length; ++i) {
            FieldContent fieldContent = (FieldContent)subviews[i].getContent();
            for (int j = 0; j < flds.length; ++j) {
                NakedObjectAssociation field = flds[j];
                if (fieldContent.getField() == field) continue block0;
            }
            view.removeView(subviews[i]);
        }
        subviews = view.getSubviews();
        for (i = 0; i < subviews.length; ++i) {
            View subview = subviews[i];
            NakedObjectAssociation field = ((FieldContent)subview.getContent()).getField();
            NakedObject value = field.get(object);
            if (field.isOneToManyAssociation()) {
                subview.update(value);
                continue;
            }
            if (field.isOneToOneAssociation()) {
                NakedObject existing = subview.getContent().getNaked();
                if (!field.getSpecification().isParseable()) {
                    boolean isDestroyed;
                    boolean changedValue = value != existing;
                    boolean bl = isDestroyed = existing != null && existing.getResolveState().isDestroyed();
                    if (!changedValue && !isDestroyed) continue;
                    View fieldView = this.createFieldView(view, object, i, field);
                    if (fieldView != null) {
                        view.replaceView(subview, this.decorateSubview(fieldView));
                        continue;
                    }
                    view.addView(new FieldErrorView("No field for " + value));
                    continue;
                }
                if (NakedObjectUtils.exists((NakedObject)value) && !NakedObjectUtils.wrappedEqual((NakedObject)value, (NakedObject)existing)) {
                    View fieldView = this.createFieldView(view, object, i, field);
                    view.replaceView(subview, this.decorateSubview(fieldView));
                    continue;
                }
                subview.refresh();
                continue;
            }
            throw new UnknownTypeException(field.getName());
        }
        block3: for (int j = 0; j < flds.length; ++j) {
            NakedObjectAssociation field = flds[j];
            for (int i2 = 0; i2 < subviews.length; ++i2) {
                FieldContent fieldContent = (FieldContent)subviews[i2].getContent();
                if (fieldContent.getField() == field) continue block3;
            }
            this.addField(view, object, field, j);
        }
    }

    private View createFieldView(View view, NakedObject object, int fieldNumber, NakedObjectAssociation field) {
        if (field == null) {
            throw new NullPointerException();
        }
        if (field.isOneToOneAssociation()) {
            NakedObjectsContext.getPersistenceSession().resolveField(object, field);
        }
        Content content1 = Toolkit.getContentFactory().createFieldContent(field, object);
        View fieldView = this.subviewDesign.createSubview(content1, view.getViewAxis(), fieldNumber);
        return fieldView;
    }
}

