/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.builder;

import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewBuilder;
import org.nakedobjects.plugins.dnd.viewer.builder.AbstractBuilderDecorator;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;

public class StackLayout
extends AbstractBuilderDecorator {
    private final boolean fixedWidth;

    public StackLayout(ViewBuilder design) {
        super(design);
        this.fixedWidth = false;
    }

    public StackLayout(ViewBuilder design, boolean fixedWidth) {
        super(design);
        this.fixedWidth = fixedWidth;
    }

    public Size getRequiredSize(View view) {
        int height = 0;
        int width = 0;
        View[] views = view.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size s = v.getRequiredSize(new Size(Integer.MAX_VALUE, Integer.MAX_VALUE));
            width = Math.max(width, s.getWidth());
            height += s.getHeight();
        }
        return new Size(width, height);
    }

    public boolean isOpen() {
        return true;
    }

    public void layout(View view, Size maximumSize) {
        Size s;
        View v;
        int i;
        boolean x = false;
        int y = 0;
        View[] subviews = view.getSubviews();
        int maxWidth = 0;
        for (i = 0; i < subviews.length; ++i) {
            v = subviews[i];
            v.layout(new Size(maximumSize));
            s = v.getRequiredSize(new Size(maximumSize));
            maxWidth = Math.max(maxWidth, s.getWidth());
        }
        for (i = 0; i < subviews.length; ++i) {
            v = subviews[i];
            s = v.getRequiredSize(new Size(maximumSize));
            if (this.fixedWidth || v.getSpecification().isAligned()) {
                s.ensureWidth(maxWidth);
            }
            v.setSize(s);
            v.setLocation(new Location(0, y));
            y += s.getHeight();
        }
    }
}

