/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.OneToManyField;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.viewer.content.AbstractCollectionContent;
import org.nakedobjects.plugins.dnd.viewer.content.ObjectField;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class OneToManyFieldImpl
extends AbstractCollectionContent
implements OneToManyField {
    private final NakedObject collection;
    private final ObjectField field;

    public OneToManyFieldImpl(NakedObject parent, NakedObject object, OneToManyAssociation association) {
        this.field = new ObjectField(parent, (NakedObjectAssociation)association);
        this.collection = object;
    }

    public Consent canClear() {
        return Veto.DEFAULT;
    }

    public Consent canDrop(Content sourceContent) {
        if (sourceContent.getNaked() instanceof NakedObject) {
            NakedObjectSpecification elementSpecification;
            NakedObject sourceAdapter = sourceContent.getNaked();
            NakedObject parentAdapter = this.field.getParent();
            NakedObject collection = this.getNaked();
            if (collection == null) {
                return new Veto("Collection not set up; can't add elements to a non-existant collection");
            }
            Consent usableInState = this.getOneToManyAssociation().isUsable(NakedObjectsContext.getAuthenticationSession(), parentAdapter);
            if (usableInState.isVetoed()) {
                return usableInState;
            }
            NakedObjectSpecification specification = sourceAdapter.getSpecification();
            if (!specification.isOfType(elementSpecification = this.getElementSpecification())) {
                return new Veto(String.format("Only objects of type %s are allowed in this collection", elementSpecification.getSingularName()));
            }
            if (parentAdapter.isPersistent() && sourceAdapter.isTransient()) {
                return new Veto("Can't set field in persistent object with reference to non-persistent object");
            }
            return this.getOneToManyAssociation().isValidToAdd(parentAdapter, sourceAdapter);
        }
        return Veto.DEFAULT;
    }

    public Consent canSet(NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        throw new NakedObjectException("Invalid call");
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
    }

    public void debugDetails(DebugString debug) {
        this.field.debugDetails(debug);
        debug.appendln("collection", (Object)this.collection);
        super.debugDetails(debug);
    }

    public NakedObject drop(Content sourceContent) {
        NakedObject object = sourceContent.getNaked();
        NakedObject parent = this.field.getParent();
        Consent perm = this.canDrop(sourceContent);
        if (perm.isAllowed()) {
            this.getOneToManyAssociation().addElement(parent, object);
        }
        return null;
    }

    public NakedObject getCollection() {
        return this.collection;
    }

    public String getDescription() {
        String type;
        String name = this.getFieldName();
        type = name.indexOf(type = this.getField().getSpecification().getSingularName()) == -1 ? " (" + type + ")" : "";
        String description = this.getOneToManyAssociation().getDescription();
        return name + type + " " + description;
    }

    public NakedObjectAssociation getField() {
        return this.field.getNakedObjectAssociation();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public String getHelp() {
        return this.getOneToManyAssociation().getHelp();
    }

    public String getIconName() {
        return null;
    }

    public Image getIconPicture(int iconHeight) {
        NakedObjectSpecification specification = this.getOneToManyAssociation().getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        if (icon == null) {
            icon = ImageFactory.getInstance().loadDefaultIcon(iconHeight, null);
        }
        return icon;
    }

    public String getId() {
        return this.getOneToManyAssociation().getId();
    }

    public NakedObject getNaked() {
        return this.collection;
    }

    public OneToManyAssociation getOneToManyAssociation() {
        return (OneToManyAssociation)this.field.getNakedObjectAssociation();
    }

    public NakedObject getParent() {
        return this.field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return this.field.getSpecification();
    }

    public boolean isCollection() {
        return true;
    }

    public Consent isEditable() {
        return this.getField().isUsable(NakedObjectsContext.getAuthenticationSession(), this.getParent());
    }

    public boolean isMandatory() {
        return this.getOneToManyAssociation().isMandatory();
    }

    public boolean isTransient() {
        return false;
    }

    public void setObject(NakedObject object) {
        throw new NakedObjectException("Invalid call");
    }

    public final String title() {
        return this.field.getName();
    }

    public String toString() {
        return this.collection + "/" + this.field.getNakedObjectAssociation();
    }

    public String windowTitle() {
        return this.title() + " for " + this.field.getParent().titleString();
    }
}

