/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.content;

import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.ParseableEntryActionParameter;
import org.nakedobjects.metamodel.util.NakedObjectUtils;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.TextParseableParameter;
import org.nakedobjects.plugins.dnd.viewer.content.AbstractTextParsableContent;
import org.nakedobjects.plugins.dnd.viewer.content.ActionHelper;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;

public class TextParseableParameterImpl
extends AbstractTextParsableContent
implements TextParseableParameter {
    private NakedObject object;
    private final NakedObject[] options;
    private final ParseableEntryActionParameter parameter;
    private final ActionHelper invocation;
    private final int index;

    public TextParseableParameterImpl(ParseableEntryActionParameter nakedObjectActionParameters, NakedObject nakedObject, NakedObject[] options, int i, ActionHelper invocation) {
        this.parameter = nakedObjectActionParameters;
        this.options = options;
        this.index = i;
        this.invocation = invocation;
        this.object = nakedObject;
    }

    public void debugDetails(DebugString debug) {
        debug.appendln("name", (Object)this.parameter.getName());
        debug.appendln("required", this.isRequired());
        debug.appendln("object", (Object)this.object);
    }

    public void entryComplete() {
    }

    public String getIconName() {
        return "";
    }

    public Image getIconPicture(int iconHeight) {
        return ImageFactory.getInstance().loadIcon("value", 12, null);
    }

    public NakedObject getNaked() {
        return this.object;
    }

    public int getNoLines() {
        return this.parameter.getNoLines();
    }

    public NakedObject[] getOptions() {
        return this.options;
    }

    public boolean isEmpty() {
        return this.object == null;
    }

    public boolean isRequired() {
        return !this.parameter.isOptional();
    }

    public boolean canClear() {
        return true;
    }

    public boolean canWrap() {
        return this.parameter.canWrap();
    }

    public void clear() {
        this.object = null;
    }

    public boolean isTransient() {
        return true;
    }

    public boolean isTextParseable() {
        return true;
    }

    public boolean isOptionEnabled() {
        return this.options != null && this.options.length > 0;
    }

    public String title() {
        return NakedObjectUtils.titleString((NakedObject)this.object);
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        toString.append("object", (Object)this.object);
        return toString.toString();
    }

    public String getParameterName() {
        return this.parameter.getName();
    }

    public NakedObjectSpecification getSpecification() {
        return this.parameter.getSpecification();
    }

    public NakedObject drop(Content sourceContent) {
        return null;
    }

    public Consent canDrop(Content sourceContent) {
        return Veto.DEFAULT;
    }

    public String titleString(NakedObject value) {
        return this.titleString(value, (FacetHolder)this.parameter, (FacetHolder)this.parameter.getSpecification());
    }

    public void parseTextEntry(String entryText) {
        this.object = this.parse(entryText);
        String reason = this.parameter.isValid(this.object, NakedObjectUtils.unwrap((NakedObject)this.object));
        if (reason != null) {
            throw new InvalidEntryException(reason);
        }
        if (!this.parameter.isOptional() && this.object == null) {
            throw new InvalidEntryException("Mandatory parameter cannot be empty");
        }
        this.invocation.setParameter(this.index, this.object);
    }

    private NakedObject parse(String entryText) {
        NakedObjectSpecification parameterSpecification = this.parameter.getSpecification();
        ParseableFacet p = (ParseableFacet)parameterSpecification.getFacet(ParseableFacet.class);
        try {
            return p.parseTextEntry(this.object, entryText);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidEntryException(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getDescription() {
        String title = this.object == null ? "" : ": " + this.object.titleString();
        String specification = this.getSpecification().getShortName();
        String type = this.getParameterName().indexOf(specification) == -1 ? "" : " (" + specification + ")";
        return this.getParameterName() + type + title + " " + this.parameter.getDescription();
    }

    public String getHelp() {
        return null;
    }

    public String getId() {
        return null;
    }

    public Consent isEditable() {
        return Allow.DEFAULT;
    }

    public int getMaximumLength() {
        return this.parameter.getMaximumLength();
    }

    public int getTypicalLineLength() {
        return this.parameter.getTypicalLineLength();
    }
}

