/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.drawing;

import org.apache.log4j.Logger;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Padding;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;

public class Bounds {
    int height;
    Logger LOG = Logger.getLogger((String)"Bounds");
    int width;
    int x;
    int y;

    public Bounds() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public Bounds(Bounds bounds) {
        this(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Bounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Bounds(Location location, Size size) {
        this(location.x, location.y, size.width, size.height);
    }

    public Bounds(Size size) {
        this(0, 0, size.width, size.height);
    }

    public boolean contains(Location location) {
        int xp = location.getX();
        int yp = location.getY();
        int xMax = this.x + this.width - 1;
        int yMax = this.y + this.height - 1;
        return xp >= this.x && xp <= xMax && yp >= this.y && yp <= yMax;
    }

    public void contract(int width, int height) {
        this.width -= width;
        this.height -= height;
    }

    public void contract(Padding padding) {
        this.height -= padding.top + padding.bottom;
        this.width -= padding.left + padding.right;
        this.x += padding.left;
        this.y += padding.top;
    }

    public void contract(Size size) {
        this.width -= size.width;
        this.height -= size.height;
    }

    public void contractHeight(int height) {
        this.height -= height;
    }

    public void contractWidth(int width) {
        this.width -= width;
    }

    public void ensureHeight(int height) {
        this.height = Math.max(this.height, height);
    }

    public void ensureWidth(int width) {
        this.width = Math.max(this.width, width);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Bounds) {
            Bounds b = (Bounds)obj;
            return b.x == this.x && b.y == this.y && b.width == this.width && b.height == this.height;
        }
        return false;
    }

    public void extend(int width, int height) {
        this.width += width;
        this.height += height;
    }

    public void extend(Padding padding) {
        this.width += padding.getLeftRight();
        this.height += padding.getTopBottom();
    }

    public void extend(Size size) {
        this.width += size.width;
        this.height += size.height;
    }

    public void extendHeight(int height) {
        this.height += height;
    }

    public void extendWidth(int width) {
        this.width += width;
    }

    public int getHeight() {
        return this.height;
    }

    public Location getLocation() {
        return new Location(this.x, this.y);
    }

    public Size getSize() {
        return new Size(this.width, this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getX2() {
        return this.x + this.width - 1;
    }

    public int getY() {
        return this.y;
    }

    public int getY2() {
        return this.y + this.height - 1;
    }

    public boolean intersects(Bounds bounds) {
        int tx1 = this.x;
        int tx2 = this.x + this.width - 1;
        int ox1 = bounds.x;
        int ox2 = bounds.x + bounds.width - 1;
        boolean xOverlap = tx1 <= ox1 && ox1 <= tx2 || tx1 <= ox2 && ox1 <= tx2 || ox1 <= tx1 && tx1 <= ox2 || ox1 <= tx2 && tx1 <= ox2;
        int ty1 = this.y;
        int ty2 = this.y + this.height - 1;
        int oy1 = bounds.y;
        int oy2 = bounds.y + bounds.height - 1;
        boolean yOverlap = ty1 <= oy1 && oy1 <= ty2 || ty1 <= oy2 && oy1 <= ty2 || oy1 <= ty1 && ty1 <= oy2 || oy1 <= ty2 && ty1 <= oy2;
        return xOverlap && yOverlap;
    }

    public void limitLocation(Size bounds) {
        if (this.x + this.width > bounds.width) {
            this.x = bounds.width - this.width;
        }
        if (this.y + this.height > bounds.height) {
            this.y = bounds.height - this.height;
        }
    }

    public boolean limitBounds(Bounds toLimit) {
        boolean limited = false;
        Location location = toLimit.getLocation();
        Size size = toLimit.getSize();
        int viewLeft = location.getX();
        int viewTop = location.getY();
        int viewRight = viewLeft + size.getWidth();
        int viewBottom = viewTop + size.getHeight();
        Size wd = this.getSize();
        int limitLeft = this.x;
        int limitTop = this.y;
        int limitRight = this.x + this.width;
        int limitBottom = this.y + this.height;
        if (viewRight > limitRight) {
            viewLeft = limitRight - size.getWidth();
            limited = true;
            this.LOG.info((Object)("right side oustide limits, moving left to " + viewLeft));
        }
        if (viewLeft < limitLeft) {
            viewLeft = limitLeft;
            limited = true;
            this.LOG.info((Object)("left side outside limit, moving left to " + viewLeft));
        }
        if (viewBottom > limitBottom) {
            viewTop = limitBottom - size.getHeight();
            limited = true;
            this.LOG.info((Object)("bottom outside limit, moving top to " + viewTop));
        }
        if (viewTop < limitTop) {
            viewTop = limitTop;
            limited = true;
            this.LOG.info((Object)("top outside limit, moving top to " + viewTop));
        }
        toLimit.setX(viewLeft);
        toLimit.setY(viewTop);
        viewBottom = viewTop + size.getHeight();
        viewRight = viewLeft + size.getWidth();
        if (viewRight > limitRight) {
            toLimit.width = wd.width;
            limited = true;
            this.LOG.info((Object)("width outside limit, reducing width to " + viewTop));
        }
        if (viewBottom > limitBottom) {
            toLimit.height = wd.height;
            limited = true;
            this.LOG.info((Object)("height outside limit, reducing height to " + viewTop));
        }
        if (limited) {
            this.LOG.info((Object)("limited " + toLimit));
        }
        return limited;
    }

    public void setBounds(Bounds bounds) {
        this.x = bounds.x;
        this.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String toString() {
        return this.x + "," + this.y + " " + this.width + "x" + this.height;
    }

    public void translate(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public void union(Bounds bounds) {
        int newX = Math.min(this.x, bounds.x);
        int newY = Math.min(this.y, bounds.y);
        this.width = Math.max(this.x + this.width, bounds.x + bounds.width) - newX;
        this.height = Math.max(this.y + this.height, bounds.y + bounds.height) - newY;
        this.x = newX;
        this.y = newY;
    }
}

