/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.focus;

import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.dnd.FocusManager;
import org.nakedobjects.plugins.dnd.View;

public abstract class AbstractFocusManager
implements FocusManager {
    protected View container;
    protected View focus;
    private final View initialFocus;

    public AbstractFocusManager(View container) {
        this(container, null);
    }

    public AbstractFocusManager(View container, View initalFocus) {
        Assert.assertNotNull((Object)container);
        this.container = container;
        this.initialFocus = initalFocus;
        this.focus = initalFocus;
    }

    private void checkCanFocusOn(View view) {
        View[] views = this.getChildViews();
        boolean valid = view == this.container.getView();
        for (int j = 0; !valid && j < views.length; ++j) {
            if (views[j] != view) continue;
            valid = true;
        }
        if (!valid) {
            // empty if block
        }
    }

    public void focusFirstChildView() {
        View[] views = this.getChildViews();
        for (int j = 0; j < views.length; ++j) {
            if (!views[j].canFocus()) continue;
            this.setFocus(views[j]);
            return;
        }
    }

    public void focusInitialChildView() {
        if (this.initialFocus == null) {
            this.focusFirstChildView();
        } else {
            this.setFocus(this.initialFocus);
        }
    }

    public void focusLastChildView() {
        View[] views = this.getChildViews();
        for (int j = views.length - 1; j > 0; --j) {
            if (!views[j].canFocus()) continue;
            this.setFocus(views[j]);
            return;
        }
    }

    public void focusNextView() {
        View[] views = this.getChildViews();
        for (int i = 0; i < views.length; ++i) {
            int j;
            if (!this.testView(views, i)) continue;
            for (j = i + 1; j < views.length; ++j) {
                if (!views[j].canFocus()) continue;
                this.setFocus(views[j]);
                return;
            }
            for (j = 0; j < i; ++j) {
                if (!views[j].canFocus()) continue;
                this.setFocus(views[j]);
                return;
            }
            return;
        }
    }

    private boolean testView(View[] views, int i) {
        View view = views[i];
        return view == this.focus;
    }

    public void focusParentView() {
        this.container.getFocusManager().setFocus(this.container.getFocusManager().getFocus());
    }

    public void focusPreviousView() {
        View[] views = this.getChildViews();
        if (views.length > 1) {
            for (int i = 0; i < views.length; ++i) {
                int j;
                if (!this.testView(views, i)) continue;
                for (j = i - 1; j >= 0; --j) {
                    if (!views[j].canFocus()) continue;
                    this.setFocus(views[j]);
                    return;
                }
                for (j = views.length - 1; j > i; --j) {
                    if (!views[j].canFocus()) continue;
                    this.setFocus(views[j]);
                    return;
                }
                return;
            }
        }
    }

    protected abstract View[] getChildViews();

    public View getFocus() {
        return this.focus;
    }

    public void setFocus(View view) {
        this.checkCanFocusOn(view);
        if (view != null && view.canFocus()) {
            if (this.focus != null && this.focus != view) {
                this.focus.focusLost();
                this.focus.markDamaged();
            }
            this.focus = view;
            this.focus.focusReceived();
            view.markDamaged();
        }
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("container", (Object)this.container);
        str.append("initialFocus", (Object)this.initialFocus);
        str.append("focus", (Object)this.focus);
        return str.toString();
    }
}

