/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.notifier;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.ObjectContent;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.content.RootCollection;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewUpdateNotifier
implements DebugInfo {
    private static final Logger LOG = Logger.getLogger(ViewUpdateNotifier.class);
    protected Hashtable<NakedObject, Vector<View>> viewListByAdapter = new Hashtable();

    public void add(View view) {
        NakedObject adapter;
        Content content = view.getContent();
        if (content != null && content.isObject() && (adapter = content.getNaked()) != null) {
            Vector<Object> viewsToNotify;
            if (this.viewListByAdapter.containsKey(adapter)) {
                viewsToNotify = this.viewListByAdapter.get(adapter);
            } else {
                viewsToNotify = new Vector();
                this.viewListByAdapter.put(adapter, viewsToNotify);
            }
            if (viewsToNotify.contains(view)) {
                throw new NakedObjectException(view + " already being notified");
            }
            viewsToNotify.addElement(view);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added " + view + " to observers for " + adapter));
            }
        }
    }

    public void debugData(DebugString buf) {
        Enumeration<NakedObject> f = this.viewListByAdapter.keys();
        while (f.hasMoreElements()) {
            NakedObject object = f.nextElement();
            Vector<View> viewsToNotify = this.viewListByAdapter.get(object);
            Enumeration<View> e = viewsToNotify.elements();
            buf.append((Object)("Views for " + object + " \n"));
            while (e.hasMoreElements()) {
                View view = e.nextElement();
                buf.append((Object)("        " + view));
                buf.append((Object)"\n");
            }
            buf.append((Object)"\n");
        }
    }

    public String debugTitle() {
        return "Views for object details (observers)";
    }

    public void remove(View view) {
        NakedObject object;
        Content content = view.getContent();
        if (content == null || !content.isObject()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing " + content + " for " + view));
        }
        if ((object = ((ObjectContent)content).getObject()) != null) {
            if (!this.viewListByAdapter.containsKey(object)) {
                throw new NakedObjectException("Tried to remove a non-existant view " + view + " from observers for " + object);
            }
            Vector<View> viewsToNotify = this.viewListByAdapter.get(object);
            Enumeration<View> e = viewsToNotify.elements();
            while (e.hasMoreElements()) {
                View v = e.nextElement();
                if (view != v.getView()) continue;
                viewsToNotify.remove(v);
                LOG.debug((Object)("removed " + view + " from observers for " + object));
                break;
            }
            if (viewsToNotify.size() == 0) {
                this.viewListByAdapter.remove(object);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("removed observer list for " + object));
                }
            }
        }
    }

    public void shutdown() {
        this.viewListByAdapter.clear();
    }

    public void invalidateViewsForChangedObjects() {
        for (NakedObject object : ViewUpdateNotifier.getUpdateNotifier().getChangedObjects()) {
            Vector<View> viewsVector;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("invalidate views for " + object));
            }
            if ((viewsVector = this.viewListByAdapter.get(object)) == null) continue;
            Enumeration<View> views = viewsVector.elements();
            while (views.hasMoreElements()) {
                View view = views.nextElement();
                LOG.debug((Object)("   - " + view));
                view.getView().invalidateContent();
            }
        }
    }

    public void removeViewsForDisposedObjects() {
        for (NakedObject objectToDispose : ViewUpdateNotifier.getUpdateNotifier().getDisposedObjects()) {
            Vector<View> viewsForObject;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("dispose views for " + objectToDispose));
            }
            if ((viewsForObject = this.viewListByAdapter.get(objectToDispose)) == null) continue;
            this.removeViews(viewsForObject);
            Vector<View> remainingViews = this.viewListByAdapter.get(objectToDispose);
            if (remainingViews != null && remainingViews.size() > 0) {
                ViewUpdateNotifier.getMessageBroker().addWarning("There are still views (within other views) for the disposed object " + objectToDispose.titleString() + ".  Only objects that are shown as root views can be properly disposed of");
                continue;
            }
            ViewUpdateNotifier.getAdapterManager().removeAdapter(objectToDispose);
        }
    }

    private void removeViews(Vector<View> views) {
        Object[] viewsArray = new View[views.size()];
        views.copyInto(viewsArray);
        View[] viewsOnWorkspace = viewsArray[0].getWorkspace().getSubviews();
        for (int i = 0; i < viewsArray.length; ++i) {
            int j;
            View view = viewsArray[i].getView();
            for (j = 0; j < viewsOnWorkspace.length; ++j) {
                if (view != viewsOnWorkspace[j]) continue;
                LOG.debug((Object)("   (root removed) " + view));
                view.getView().dispose();
                break;
            }
            for (j = 0; j < viewsOnWorkspace.length; ++j) {
                if (!(viewsOnWorkspace[j].getContent() instanceof RootCollection)) continue;
                View[] subviewsOfRootView = viewsOnWorkspace[j].getSubviews();
                for (int k = 0; k < subviewsOfRootView.length; ++k) {
                    if (subviewsOfRootView[k] != view) continue;
                    LOG.debug((Object)("   (element removed) " + view));
                    view.getView().dispose();
                }
            }
            for (j = 0; j < viewsOnWorkspace.length; ++j) {
                if (!viewsOnWorkspace[j].contains(view)) continue;
                LOG.debug((Object)("   (invalidated) " + view));
                View parent = view.getParent();
                parent.invalidateContent();
            }
        }
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AdapterManager getAdapterManager() {
        return ViewUpdateNotifier.getPersistenceSession().getAdapterManager();
    }

    private static MessageBroker getMessageBroker() {
        return NakedObjectsContext.getMessageBroker();
    }

    private static UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }
}

