/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.table;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.plugins.dnd.CollectionContent;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.SubviewSpec;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewRequirement;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.builder.CollectionElementBuilder;
import org.nakedobjects.plugins.dnd.viewer.builder.StackLayout;
import org.nakedobjects.plugins.dnd.viewer.table.TableAxis;
import org.nakedobjects.plugins.dnd.viewer.table.TableRowSpecification;
import org.nakedobjects.plugins.dnd.viewer.table.TypeBasedColumnWidthStrategy;

public abstract class AbstractTableSpecification
extends AbstractCompositeViewSpecification
implements SubviewSpec {
    private static final Logger LOG = Logger.getLogger(AbstractTableSpecification.class);
    private ViewSpecification rowSpecification;

    public AbstractTableSpecification() {
        this.builder = new StackLayout(new CollectionElementBuilder(this));
        this.rowSpecification = new TableRowSpecification();
    }

    public boolean canDisplay(Content content, ViewRequirement requirement) {
        if (!content.isCollection() || !requirement.is(4)) {
            return false;
        }
        CollectionContent collectionContent = (CollectionContent)((Object)content);
        NakedObjectSpecification elementSpecification = collectionContent.getElementSpecification();
        NakedObjectAssociation[] fields = elementSpecification.getAssociations(NakedObjectAssociationFilters.STATICALLY_VISIBLE_ASSOCIATIONS);
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isOneToOneAssociation()) continue;
            return true;
        }
        return false;
    }

    public View createSubview(Content content, ViewAxis axis, int fieldNumber) {
        return this.rowSpecification.createView(content, axis);
    }

    protected ViewAxis axis(Content content) {
        NakedObjectSpecification elementSpecification = ((CollectionContent)((Object)content)).getElementSpecification();
        NakedObjectAssociation[] accessibleFields = elementSpecification.getAssociations(NakedObjectAssociationFilters.STATICALLY_VISIBLE_ASSOCIATIONS);
        TableAxis tableAxis = new TableAxis(this.tableFields(accessibleFields, content));
        tableAxis.setupColumnWidths(new TypeBasedColumnWidthStrategy());
        return tableAxis;
    }

    protected View decorateView(View view) {
        TableAxis tableAxis = (TableAxis)view.getViewAxis();
        tableAxis.setRoot(view);
        return view;
    }

    protected abstract View doCreateView(View var1, Content var2, ViewAxis var3);

    public String getName() {
        return "Standard Table";
    }

    public boolean isReplaceable() {
        return false;
    }

    private NakedObjectAssociation[] tableFields(NakedObjectAssociation[] viewFields, Content content) {
        for (int i = 0; i < viewFields.length; ++i) {
            NakedObjectAssociation nakedObjectAssociation = viewFields[i];
            LOG.debug((Object)("column " + nakedObjectAssociation.getSpecification()));
        }
        NakedObjectAssociation[] tableFields = new NakedObjectAssociation[viewFields.length];
        int c = 0;
        for (int i = 0; i < viewFields.length; ++i) {
            if (viewFields[i] instanceof OneToManyAssociation) continue;
            tableFields[c++] = viewFields[i];
        }
        NakedObjectAssociation[] results = new NakedObjectAssociation[c];
        System.arraycopy(tableFields, 0, results, 0, c);
        return results;
    }
}

