/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.table;

import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.viewer.table.ColumnWidthStrategy;

public class TableAxis
implements ViewAxis {
    private final NakedObjectAssociation[] columns;
    private final String[] columnName;
    private int rowHeaderOffet;
    private View table;
    private final int[] widths;

    public TableAxis(NakedObjectAssociation[] columns) {
        this.columns = columns;
        this.widths = new int[columns.length];
        this.columnName = new String[columns.length];
        for (int i = 0; i < this.widths.length; ++i) {
            this.columnName[i] = columns[i].getName();
        }
    }

    public void ensureOffset(int offset) {
        this.rowHeaderOffet = Math.max(this.rowHeaderOffet, offset + 5);
    }

    public int getColumnAt(int xPosition) {
        int edge = this.getHeaderOffset();
        int cols = this.getColumnCount() + 1;
        for (int i = 0; i < cols; ++i) {
            if (xPosition >= edge - 1 && xPosition <= edge + 1) {
                return -1;
            }
            if (xPosition < edge - 1) {
                return i;
            }
            edge += this.getColumnWidth(i);
        }
        return -1;
    }

    public int getColumnBorderAt(int xPosition) {
        int edge = this.getHeaderOffset();
        int cols = this.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            if (xPosition >= edge - 1 && xPosition <= edge + 1) {
                return i;
            }
            edge += this.getColumnWidth(i);
        }
        if (xPosition >= edge - 1 && xPosition <= edge + 1) {
            return this.getColumnCount();
        }
        return -1;
    }

    public int getColumnCount() {
        return this.columnName.length;
    }

    public String getColumnName(int column) {
        return this.columnName[column];
    }

    public int getColumnWidth(int column) {
        return this.widths[column];
    }

    public NakedObjectAssociation getFieldForColumn(int column) {
        return this.columns[column];
    }

    public int getHeaderOffset() {
        return this.rowHeaderOffet;
    }

    public int getLeftEdge(int resizeColumn) {
        int width = this.getHeaderOffset();
        int cols = this.getColumnCount();
        for (int i = 0; i < resizeColumn && i < cols; ++i) {
            width += this.getColumnWidth(i);
        }
        return width;
    }

    public void invalidateLayout() {
        View[] rows = this.table.getSubviews();
        for (int i = 0; i < rows.length; ++i) {
            rows[i].invalidateLayout();
        }
        this.table.invalidateLayout();
    }

    public void setOffset(int offset) {
        this.rowHeaderOffet = offset;
    }

    public void setRoot(View view) {
        this.table = view;
    }

    public void setupColumnWidths(ColumnWidthStrategy strategy) {
        for (int i = 0; i < this.widths.length; ++i) {
            this.widths[i] = strategy.getPreferredWidth(i, this.columns[i]);
        }
    }

    public void setWidth(int index, int width) {
        this.widths[index] = width;
    }
}

