/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.undo;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dnd.viewer.undo.Command;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;

public class SetValueCommand
implements Command {
    private final String description;
    private final OneToOneAssociation value;
    private final NakedObject object;
    private final String oldValue;

    public SetValueCommand(NakedObject object, OneToOneAssociation value) {
        EncodableFacet facet = (EncodableFacet)value.getFacet(EncodableFacet.class);
        this.oldValue = facet.toEncodedString(object);
        this.object = object;
        this.value = value;
        this.description = "reset the value to " + this.oldValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void undo() {
        EncodableFacet facet = (EncodableFacet)this.value.getFacet(EncodableFacet.class);
        NakedObject obj = facet.fromEncodedString(this.oldValue);
        NakedObject adapter = SetValueCommand.getAdapterManager().adapterFor((Object)obj);
        this.value.setAssociation(this.object, adapter);
    }

    public void execute() {
    }

    public String getName() {
        return "entry";
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AdapterManager getAdapterManager() {
        return SetValueCommand.getPersistenceSession().getAdapterManager();
    }
}

