/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.field;

import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.facets.value.ColorValueFacet;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.TextParseableContent;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewRequirement;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.border.DisposeOverlay;
import org.nakedobjects.plugins.dnd.viewer.builder.AbstractFieldSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.view.field.ColorFieldOverlay;
import org.nakedobjects.plugins.dnd.viewer.view.field.TextParseableFieldAbstract;

public class ColorField
extends TextParseableFieldAbstract {
    private int color;

    public ColorField(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        Color color = this.hasFocus() ? Toolkit.getColor("color.primary1") : (this.getParent().getState().isObjectIdentified() ? Toolkit.getColor("color.identified") : (this.getParent().getState().isRootViewIdentified() ? Toolkit.getColor("color.primary2") : Toolkit.getColor("color.secondary1")));
        int top = 0;
        int left = 0;
        Size size = this.getSize();
        int w = size.getWidth() - 1;
        int h = size.getHeight() - 1;
        canvas.drawRectangle(left, top, w, h, color);
        canvas.drawSolidRectangle(++left, ++top, --w, --h, Toolkit.getColor(this.getColor()));
    }

    public void firstClick(Click click) {
        if (((TextParseableContent)this.getContent()).isEditable().isAllowed()) {
            DisposeOverlay overlay = new DisposeOverlay(new ColorFieldOverlay(this));
            Location location = this.getAbsoluteLocation();
            overlay.setLocation(location);
            this.getViewManager().setOverlayView(overlay);
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("text.normal").getAscent();
    }

    int getColor() {
        TextParseableContent content = (TextParseableContent)this.getContent();
        ColorValueFacet col = (ColorValueFacet)content.getSpecification().getFacet(ColorValueFacet.class);
        return col.colorValue(content.getNaked());
    }

    public Size getMaximumSize() {
        return new Size(45, 15);
    }

    protected void save() {
        try {
            this.parseEntry("" + this.color);
        }
        catch (InvalidEntryException e) {
            throw new NotYetImplementedException();
        }
    }

    void setColor(int color) {
        this.color = color;
        this.initiateSave(false);
    }

    public static class Specification
    extends AbstractFieldSpecification {
        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return content.isTextParseable() && content.getSpecification().getFacet(ColorValueFacet.class) != null;
        }

        public View createView(Content content, ViewAxis axis) {
            return new ColorField(content, this, axis);
        }

        public String getName() {
            return "Color";
        }
    }
}

