/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.field;

import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.TextParseableContent;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.view.field.TextField;

public class SingleLineTextField
extends TextField {
    private static final int LIMIT = 20;
    private int offset = 0;

    public SingleLineTextField(TextParseableContent content, ViewSpecification specification, ViewAxis axis, boolean showLines) {
        super(content, specification, axis, showLines, 1);
    }

    protected void align() {
        String line = this.textContent.getText(0);
        if (line != null) {
            int cursorPosition;
            int maxWidth = this.getMaxFieldWidth();
            int leftLimit = this.offset + 20;
            int rightLimit = this.offset + maxWidth - 20;
            if (this.cursor.getCharacter() > line.length()) {
                this.cursor.end();
            }
            if ((cursorPosition = style.stringWidth(line.substring(0, this.cursor.getCharacter()))) > rightLimit) {
                this.offset += cursorPosition - rightLimit;
                this.offset = Math.min(style.stringWidth(line), this.offset);
            } else if (cursorPosition < leftLimit) {
                this.offset -= leftLimit - cursorPosition;
                this.offset = Math.max(0, this.offset);
            }
        }
    }

    protected void drawHighlight(Canvas canvas, int maxWidth) {
        String line;
        int baseline = this.getBaseline();
        int top = baseline - style.getAscent();
        int from = this.selection.from().getCharacter();
        int to = this.selection.to().getCharacter();
        if (to >= (line = this.textContent.getText(0)).length()) {
            to = line.length();
        }
        if (from >= line.length()) {
            from = line.length();
        }
        if (line != null) {
            int start = style.stringWidth(line.substring(0, from));
            int end = style.stringWidth(line.substring(0, to));
            canvas.drawSolidRectangle(start + HPADDING, top, end - start, style.getLineHeight(), Toolkit.getColor("color.text.highlight"));
        }
    }

    protected void drawLines(Canvas canvas, Color color, int width) {
        int baseline = this.getBaseline();
        canvas.drawLine(HPADDING, baseline, HPADDING + width, baseline, color);
    }

    protected void drawText(Canvas canvas, Color textColor, int width) {
        String[] lines = this.textContent.getDisplayLines();
        if (lines.length > 1) {
            throw new NakedObjectException("Single line text field should contain a string that contains no line breaks; contains " + lines.length);
        }
        String chars = lines[0];
        if (chars == null) {
            throw new NakedObjectException();
        }
        if (chars.endsWith("\n")) {
            throw new RuntimeException();
        }
        int baseline = this.getBaseline();
        if (this.hasFocus() && this.canChangeValue().isAllowed()) {
            int at = Math.min(this.cursor.getCharacter(), chars.length());
            int pos = style.stringWidth(chars.substring(0, at)) - this.offset + HPADDING;
            canvas.drawLine(pos, baseline + style.getDescent(), pos, baseline - style.getAscent(), Toolkit.getColor("color.text.cursor"));
        }
        canvas.drawText(chars, HPADDING - this.offset, baseline, textColor, style);
    }

    public void setMaximumSize(Size size) {
        int width = Math.max(180, size.getWidth() - HPADDING);
        this.setWidth(width);
        this.invalidateLayout();
    }
}

