/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.help;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.NullContent;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextBlockTarget;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextContent;

public class HelpView
extends AbstractView
implements TextBlockTarget {
    private static final int HEIGHT = 350;
    private static final int WIDTH = 400;
    private static final int MAX_TEXT_WIDTH = 375;
    private final TextContent content;

    public HelpView(String name, String description, String help) {
        super(new NullContent());
        String text = (name == null || name.trim().equals("") ? "" : name + "\n") + (description == null || description.trim().equals("") ? "" : description + "\n") + (help == null ? "" : help);
        this.content = new TextContent(this, 10, 0);
        this.content.setText(text);
    }

    public void draw(Canvas canvas) {
        int x = 0;
        int y = 0;
        int xEntent = this.getSize().getWidth() - 1;
        int yExtent = this.getSize().getHeight() - 1;
        int arc = 9;
        canvas.drawSolidRectangle(x + 2, y + 2, xEntent - 4, yExtent - 4, Toolkit.getColor("color.white"));
        Color black = Toolkit.getColor("color.black");
        canvas.drawRoundedRectangle(x, y++, xEntent, yExtent, 9, 9, black);
        canvas.drawRoundedRectangle(x + 1, y++, xEntent - 2, yExtent - 2, 9, 9, Toolkit.getColor("color.secondary2"));
        canvas.drawRoundedRectangle(x + 2, y++, xEntent - 4, yExtent - 4, 9, 9, black);
        y += VPADDING;
        canvas.drawText("Help", x += 10, y += Toolkit.getText("text.title").getTextHeight(), black, Toolkit.getText("text.title"));
        String[] lines = this.content.getDisplayLines();
        for (int i = 0; i < lines.length; ++i) {
            canvas.drawText(lines[i], x, y += Toolkit.getText("text.normal").getLineHeight(), 375, black, Toolkit.getText("text.normal"));
        }
    }

    public Size getMaximumSize() {
        return new Size(400, 350);
    }

    public Size getRequiredSize(Size maximumSize) {
        int height = Math.min(350, maximumSize.getHeight());
        int width = Math.min(400, maximumSize.getWidth());
        return new Size(width, height);
    }

    public void firstClick(Click click) {
        this.getViewManager().clearOverlayView(this);
    }

    public int getMaxFieldWidth() {
        return 380;
    }

    public Text getText() {
        return Toolkit.getText("text.normal");
    }
}

