/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.message;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.FocusManager;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.ViewAreaType;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;
import org.nakedobjects.plugins.dnd.viewer.view.message.MessageContent;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;

class MessageView
extends AbstractView {
    private static final int MAX_TEXT_WIDTH = 400;
    private static final int LEFT = 20;
    private static final int RIGHT = 20;
    private static final int TOP = 15;
    private static final int PADDING = 10;
    private Image errorIcon;
    private FocusManager focusManager;

    protected MessageView(MessageContent content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
        String iconName = ((MessageContent)this.getContent()).getIconName();
        this.errorIcon = ImageFactory.getInstance().loadIcon(iconName, 32, null);
        if (this.errorIcon == null) {
            this.errorIcon = ImageFactory.getInstance().loadDefaultIcon(32, null);
        }
    }

    public Size getMaximumSize() {
        Size size = new Size();
        String message = ((MessageContent)this.getContent()).getMessage();
        String heading = ((MessageContent)this.getContent()).title();
        size.ensureHeight(this.errorIcon.getHeight());
        Text text = Toolkit.getText("text.normal");
        Text titleText = Toolkit.getText("text.title");
        size.extendWidth(text.stringWidth(message, 400));
        int textHeight = titleText.getLineHeight();
        size.ensureHeight(textHeight += text.stringHeight(message, 400));
        size.ensureWidth(titleText.stringWidth(heading));
        size.extendWidth(this.errorIcon.getWidth());
        size.extendWidth(10);
        size.extend(40, 30);
        return size;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        String message = ((MessageContent)this.getContent()).getMessage();
        String heading = ((MessageContent)this.getContent()).title();
        canvas.clearBackground(this, Toolkit.getColor("color.white"));
        canvas.drawImage(this.errorIcon, 20, 15);
        int x = 20 + this.errorIcon.getWidth() + 10;
        int y = 18 + Toolkit.getText("text.normal").getAscent();
        Color black = Toolkit.getColor("color.black");
        if (!heading.equals("")) {
            Text title = Toolkit.getText("text.title");
            canvas.drawText(heading, x, y, black, title);
            y += title.getLineHeight();
        }
        canvas.drawText(message, x, y, 400, black, Toolkit.getText("text.normal"));
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return ViewAreaType.VIEW;
    }

    public FocusManager getFocusManager() {
        return this.focusManager == null ? super.getFocusManager() : this.focusManager;
    }

    public void setFocusManager(FocusManager focusManager) {
        this.focusManager = focusManager;
    }
}

