/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.text;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.view.text.CursorPosition;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextBlock;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextBlockTarget;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextSelection;

public class TextContent {
    private static final Logger LOG = Logger.getLogger(TextContent.class);
    private static final Logger UI_LOG = Logger.getLogger((String)("ui." + TextContent.class.getName()));
    public static final int NO_WRAPPING = 1;
    public static final int WRAPPING = 0;
    private final Vector blocks;
    private final TextBlockTarget target;
    private int displayFromLine;
    private int availableDisplayLines;
    private final int wrap;

    public TextContent(TextBlockTarget target, int noLines, int wrapStyle) {
        this.target = target;
        this.wrap = wrapStyle;
        this.blocks = new Vector();
        this.availableDisplayLines = noLines;
        this.displayFromLine = 0;
        this.addBlock("");
        this.alignDisplay(0);
    }

    private void addBlock(String text) {
        TextBlock block = new TextBlock(this.target, text, this.wrap == 0);
        LOG.debug((Object)("add block " + block));
        this.blocks.addElement(block);
    }

    public int getNoDisplayLines() {
        return this.availableDisplayLines;
    }

    public void alignDisplay(int line) {
        int noContentLines = this.getNoLinesOfContent();
        int lastLine = noContentLines - 1;
        int displayToLine = Math.min(this.displayFromLine + this.availableDisplayLines, noContentLines);
        if (noContentLines <= this.availableDisplayLines) {
            this.displayFromLine = 0;
        } else {
            if (line >= displayToLine) {
                displayToLine = line + 3;
                displayToLine = Math.min(displayToLine, lastLine);
                this.displayFromLine = displayToLine - this.availableDisplayLines + 1;
                this.displayFromLine = Math.max(this.displayFromLine, 0);
            }
            if (line < this.displayFromLine) {
                this.displayFromLine = line;
                displayToLine = this.displayFromLine + this.availableDisplayLines - 1;
                if (displayToLine >= noContentLines) {
                    displayToLine = lastLine;
                    this.displayFromLine = Math.max(0, displayToLine - this.availableDisplayLines);
                }
            }
        }
        LOG.debug((Object)("display line " + line + " " + this.displayFromLine + "~" + displayToLine));
    }

    public void breakBlock(CursorPosition cursorAt) {
        BlockToLineMapping mapping = this.findBlockFor(cursorAt.getLine());
        TextBlock newBlock = mapping.textBlock.splitAt(mapping.line, cursorAt.getCharacter());
        this.blocks.insertElementAt(newBlock, mapping.index + 1);
    }

    public void delete(TextSelection selection) {
        CursorPosition from = selection.from();
        CursorPosition to = selection.to();
        BlockToLineMapping fromMapping = this.findBlockFor(from.getLine());
        int fromBlock = fromMapping.index;
        int fromLine = fromMapping.line;
        int fromCharacter = from.getCharacter();
        BlockToLineMapping toMapping = this.findBlockFor(to.getLine());
        int toBlock = toMapping.index;
        int toLine = toMapping.line;
        int toCharacter = to.getCharacter();
        if (fromBlock == toBlock) {
            TextBlock block = (TextBlock)this.blocks.elementAt(fromBlock);
            block.delete(fromLine, fromCharacter, toLine, toCharacter);
        } else {
            TextBlock block = (TextBlock)this.blocks.elementAt(toBlock);
            block.deleteTo(toLine, toCharacter);
            block = (TextBlock)this.blocks.elementAt(fromBlock);
            block.deleteFrom(fromLine, fromCharacter);
            fromMapping.textBlock.join(toMapping.textBlock);
            this.blocks.removeElementAt(toMapping.index);
            for (int i = fromBlock + 1; i < toBlock; ++i) {
                this.blocks.removeElementAt(i);
            }
        }
    }

    public void deleteLeft(CursorPosition cursorAt) {
        BlockToLineMapping mapping = this.findBlockFor(cursorAt.getLine());
        if (mapping == null || mapping.textBlock == null) {
            throw new NakedObjectException("invalid block " + mapping + " for line " + cursorAt.getLine());
        }
        mapping.textBlock.deleteLeft(mapping.line, cursorAt.getCharacter());
    }

    public void deleteRight(CursorPosition cursorAt) {
        BlockToLineMapping mapping = this.findBlockFor(cursorAt.getLine());
        mapping.textBlock.deleteRight(mapping.line, cursorAt.getCharacter());
    }

    private BlockToLineMapping findBlockFor(int line) {
        if (line < 0) {
            throw new IllegalArgumentException("Line must be greater than, or equal to, zero: " + line);
        }
        int lineWithinBlock = line;
        for (int i = 0; i < this.blocks.size(); ++i) {
            TextBlock block = (TextBlock)this.blocks.elementAt(i);
            int noLines = block.noLines();
            if (lineWithinBlock < noLines) {
                UI_LOG.debug((Object)("block " + i + ", line " + lineWithinBlock));
                return new BlockToLineMapping(i, block, lineWithinBlock);
            }
            lineWithinBlock -= noLines;
        }
        return null;
    }

    public String getText() {
        StringBuffer content = new StringBuffer();
        Enumeration e = this.blocks.elements();
        while (e.hasMoreElements()) {
            TextBlock block = (TextBlock)e.nextElement();
            if (content.length() > 0) {
                content.append("\n");
            }
            content.append(block.getText());
        }
        return content.toString();
    }

    public String getText(int forLine) {
        BlockToLineMapping block = this.findBlockFor(forLine);
        if (block == null) {
            return null;
        }
        return block.textBlock.getLine(block.line);
    }

    public String getText(TextSelection selection) {
        CursorPosition from = selection.from();
        CursorPosition to = selection.to();
        int line = from.getLine();
        String text = this.getText(line);
        if (from.getLine() == to.getLine()) {
            return text.substring(from.getCharacter(), to.getCharacter());
        }
        StringBuffer str = new StringBuffer();
        str.append(text.substring(from.getCharacter()));
        for (int i = line + 1; i < line + (to.getLine() - from.getLine()); ++i) {
            text = this.getText(i);
            str.append(text);
        }
        text = this.getText(line + (to.getLine() - from.getLine()));
        str.append(text.substring(0, to.getCharacter()));
        return str.toString();
    }

    public void insert(CursorPosition cursorAt, String characters) {
        Assert.assertNotNull((Object)cursorAt);
        BlockToLineMapping block = this.findBlockFor(cursorAt.getLine());
        Assert.assertNotNull((String)("failed to get block for line " + cursorAt.getLine()), (Object)block);
        block.textBlock.insert(block.line, cursorAt.getCharacter(), characters);
    }

    public int getNoLinesOfContent() {
        int lineCount = 0;
        Enumeration e = this.blocks.elements();
        while (e.hasMoreElements()) {
            lineCount += ((TextBlock)e.nextElement()).noLines();
        }
        return lineCount;
    }

    public void setText(String text) {
        this.blocks.removeAllElements();
        if (text.equals("")) {
            this.addBlock("");
        } else {
            StringTokenizer st = new StringTokenizer(text, "\n");
            while (st.hasMoreTokens()) {
                this.addBlock(st.nextToken());
            }
        }
    }

    public String toString() {
        ToString content = new ToString((Object)this);
        content.append("field", (Object)this.target);
        content.append("lines", this.availableDisplayLines);
        content.append("blocks=", this.blocks.size());
        return content.toString();
    }

    public String[] getDisplayLines() {
        String[] lines = new String[this.availableDisplayLines];
        int i = 0;
        int j = this.displayFromLine;
        while (i < lines.length) {
            String line = this.getText(j);
            lines[i] = line == null ? "" : line;
            ++i;
            ++j;
        }
        return lines;
    }

    public int getDisplayFromLine() {
        return this.displayFromLine;
    }

    public void setNoDisplayLines(int noDisplayLines) {
        this.availableDisplayLines = noDisplayLines;
    }

    public void increaseDepth() {
        ++this.availableDisplayLines;
    }

    public boolean decreaseDepth() {
        if (this.availableDisplayLines > 1) {
            --this.availableDisplayLines;
            return true;
        }
        return false;
    }

    int cursorAtLine(Location atLocation) {
        LOG.debug((Object)("pointer at " + atLocation));
        int y = atLocation.getY();
        int lineIndex = this.displayFromLine + y / this.target.getText().getLineHeight();
        lineIndex = Math.max(lineIndex, 0);
        return lineIndex;
    }

    int cursorAtCharacter(Location atLocation, int lineOffset) {
        String text = this.getText(lineOffset);
        if (text == null) {
            for (int i = lineOffset; i >= 0; --i) {
                String text2 = this.getText(i);
                if (text2 == null) continue;
                int at = text2.length();
                LOG.debug((Object)("character at " + at + " line " + lineOffset));
                return at;
            }
        }
        int x = atLocation.getX() - 3;
        int at = 0;
        int endAt = text.length();
        for (int width = 0; at < endAt && x > width; width += this.target.getText().charWidth(text.charAt(at)), ++at) {
        }
        LOG.debug((Object)("character at " + at + " line " + lineOffset));
        return at;
    }

    private static class BlockToLineMapping {
        TextBlock textBlock;
        int index;
        int line;

        public BlockToLineMapping(int blockIndex, TextBlock block, int line) {
            this.index = blockIndex;
            this.textBlock = block;
            this.line = line;
        }
    }
}

