package org.nakedobjects.plugins.dndviewer;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectApplicationException;


public final class BackgroundThread {
    private static final Logger LOG = Logger.getLogger(BackgroundTask.class);

    private BackgroundThread() {}

    public static void run(final View view, final BackgroundTask task) {
        newRun(view, task);

        if (true) {
            return;
        }

        LOG.debug("creating background thread for task " + task);
        // Thread t = new Thread("nofBackground") {
        // public void run() {
        try {
            /*
             * view.getState().setActive(); view.getFeedbackManager().setBusy(view, task); LOG.debug("running
             * background thread for task "+ task); repaint(view);
             */
            task.execute();

        } catch (final Throwable e) {
            if (!(e instanceof NakedObjectApplicationException)) {
                final String message = "Error while running background task " + task.getName();
                LOG.error(message, e);
            }
            view.getFeedbackManager().showException(e);

        } finally {
            /*
             * view.getState().setInactive(); view.getFeedbackManager().clearBusy(view); repaint(view);
             */
        }
        // }
        // };

        // t.start();
    }

    public static void newRun(final View view, final BackgroundTask task) {
        LOG.debug("creating background thread for task " + task);
        final Thread t = new Thread("nofBackground") {
            @Override
            public void run() {
                try {
                    view.getState().setActive();
                    view.getFeedbackManager().setBusy(view, task);
                    scheduleRepaint(view);

                    LOG.debug("running background thread for task " + task);
                    task.execute();

                } catch (Throwable e) {
                    if (!(e instanceof NakedObjectApplicationException)) {
                        String message = "Error while running background task " + task.getName();
                        LOG.error(message, e);
                    }
                    view.getFeedbackManager().showException(e);

                } finally {
                    view.getState().setInactive();
                    view.getFeedbackManager().clearBusy(view);
                    scheduleRepaint(view);
                }
            }
        };

        t.start();
    }

    private static void scheduleRepaint(final View view) {
        view.markDamaged();
        view.getViewManager().scheduleRepaint();
    }
}
// Copyright (c) Naked Objects Group Ltd.
