package org.nakedobjects.plugins.dndviewer;

import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.undo.UndoStack;


public interface Viewer {
    void markDamaged(final Bounds bounds);

    boolean hasFocus(final View view);

    UndoStack getUndoStack();

    void saveCurrentFieldEntry();

    void setKeyboardFocus(final View view);

    boolean isRunningAsExploration();

    void clearAction();

    /**
     * Force a repaint of the damaged area of the viewer.
     */
    void scheduleRepaint();

    void addToNotificationList(final View view);

    void removeFromNotificationList(final View view);

    void setBackground(Background background);

    InteractionSpy getSpy();

    void clearOverlayView();

    void clearOverlayView(final View view);

    void setOverlayView(final View view);

    void showInOverlay(Content content, Location location);

    // TODO should this be an extension?
    String selectFilePath(final String title, final String directory);

    void setClipboard(String clip, Class<?> class1);

    Object getClipboard(Class<?> class1);

    void disposeUnneededViews();

    /*
     * 
     * void initSize();
     * 
     * void addSpyAction(final String actionMessage);
     * 
     * void close(); // TODO remove this method; use clearOverlay instead //void disposeOverlayView();
     * 
     * View dragFrom(final Location location);
     * 
     * Drag dragStart(final DragStart start);
     * 
     * void firstClick(final Click click);
     * 
     * Bounds getOverlayBounds();
     * 
     * View getOverlayView();
     * 
     * View identifyView(final Location location, final boolean includeOverlay);
     * 
     * void init();
     * 
     * boolean isBusy(final View view);
     * 
     * boolean isShowingMouseSpy();
     * 
     * void menuOptions(final UserActionSet options);
     * 
     * void mouseDown(final Click click);
     * 
     * void mouseMoved(final Location location);
     * 
     * void mouseUp(final Click click);
     * 
     * void paint(final Graphics g);
     * 
     * View pickupContent(final Location location);
     * 
     * View pickupView(final Location location);
     * 
     * void secondClick(final Click click);
     * 
     * void setCursor(final Cursor cursor);
     * 
     * void setExploration(final boolean asExploration);
     * 
     * void setListener(final ObjectViewingMechanismListener listener);
     * 
     * void setRenderingArea(final RenderingArea renderingArea);
     * 
     * void setRootView(final View rootView);
     * 
     * void setHelpViewer(final HelpViewer helpViewer);
     * 
     * void setShowMouseSpy(final boolean showDeveloperStatus);
     * 
     * void showSpy();
     * 
     * void sizeChange();
     * 
     * void thirdClick(final Click click);
     * 
     * String toString();
     * 
     * void translate(final MouseEvent me);
     * 
     * ViewAreaType viewAreaType(final Location location);
     * 
     * boolean isOverlayAvailable();
     * 
     * void makeRootFocus();
     * 
     * void openHelp(final View forView);
     * 
     * public void popupMenu(View identifiedView, Location at, boolean forView, boolean includeExploration,
     * boolean includeDebug) {}
     */
}
// Copyright (c) Naked Objects Group Ltd.
