package org.nakedobjects.plugins.dndviewer.viewer;

import java.util.Hashtable;

import org.nakedobjects.plugins.dndviewer.ColorsAndFonts;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;


public class AwtColorsAndFonts implements ColorsAndFonts {
    private final Hashtable colors = new Hashtable();
    private int defaultBaseline;
    private int defaultFieldHeight;
    private final Hashtable fonts = new Hashtable();

    public int defaultBaseline() {
        if (defaultBaseline == 0) {
            final int iconSize = getText("normal").getAscent();
            defaultBaseline = View.VPADDING + iconSize;
        }
        return defaultBaseline;
    }

    public int defaultFieldHeight() {
        if (defaultFieldHeight == 0) {
            defaultFieldHeight = getText("normal").getTextHeight();
        }
        return defaultFieldHeight;
    }

    public Color getColor(final String name) {
        Color color = (Color) colors.get(name);
        if (color == null && name.startsWith("background.window.")) {
            color = new AwtColor(name, (AwtColor) getColor("background.window"));
            colors.put(name, color);
        }
        return color;

    }

    public Color getColor(final int rgbColor) {
        return new AwtColor(rgbColor);
    }

    public Text getText(final String name) {
        return (Text) fonts.get(name);
    }

    public void init() {
        // core color scheme
        setColor("black", "#000000");
        setColor("white", "#ffffff");
        setColor("primary1", "#666699");
        setColor("primary2", "#9999cc");
        setColor("primary3", "#ccccff");
        setColor("secondary1", "#666666");
        setColor("secondary2", "#999999");
        setColor("secondary3", "#cccccc");

        // background colors
        setColor("background.application", "#e0e0e0");
        setColor("background.window", getColor("white"));
        setColor("background.value-menu", getColor("primary3")); // "#ccffcc");
        setColor("background.content-menu", getColor("primary3")); // "#ffcccc");
        setColor("background.view-menu", getColor("secondary3")); // "#ffccff");
        setColor("background.workspace-menu", getColor("secondary3")); // "#cccccc");

        // menu colors
        setColor("menu.normal", getColor("black"));
        setColor("menu.disabled", getColor("secondary1"));
        setColor("menu.reversed", getColor("white"));

        // state colors
        setColor("identified", getColor("primary3")); // "#0099ff");
        setColor("valid", "#32CD32");
        setColor("invalid", "#ee1919");
        setColor("error", "#ee1919");
        setColor("active", "#ff0000");
        setColor("out-of-sync", "#662200");

        // text colors
        setColor("text.saved", getColor("secondary1"));
        setColor("text.edit", getColor("primary1")); // "#009933");
        setColor("text.cursor", getColor("primary1"));
        setColor("text.highlight", getColor("primary3"));

        // debug outline colors
        setColor("debug.baseline", AwtColor.DEBUG_BASELINE);
        setColor("debug.bounds.border", AwtColor.DEBUG_BORDER_BOUNDS);
        setColor("debug.bounds.draw", AwtColor.DEBUG_DRAW_BOUNDS);
        setColor("debug.bounds.repaint", AwtColor.DEBUG_REPAINT_BOUNDS);
        setColor("debug.bounds.view", AwtColor.DEBUG_VIEW_BOUNDS);

        // fonts
        setText("control", "SansSerif-bold-12");
        setText("title", "SansSerif-bold-12");
        setText("small-title", "SansSerif-bold-12");
        setText("status", "SansSerif--12");
        setText("large-icon", "SansSerif-bold-12");
        setText("mandatory-label", "SansSerif-bold-11");
        setText("label", "SansSerif--11");
        setText("menu", "SansSerif--12");
        setText("normal", "SansSerif-plain-12");
    }

    private void setColor(final String name, final Color defaultColor) {
        setColor(name, (AwtColor) defaultColor);
    }

    private void setColor(final String name, final AwtColor defaultColor) {
        if (getColor(name) == null) {
            final AwtColor color = new AwtColor(name, defaultColor);
            colors.put(name, color);
        }
    }

    private void setColor(final String name, final String defaultColor) {
        if (getColor(name) == null) {
            final AwtColor color = new AwtColor(name, defaultColor);
            colors.put(name, color);
        }
    }

    private void setText(final String name, final String defaultFont) {
        if (getText(name) == null) {
            final AwtText font = new AwtText(name, defaultFont);
            fonts.put(name, font);
        }
    }
}

// Copyright (c) Naked Objects Group Ltd.
