package org.nakedobjects.plugins.dndviewer.viewer;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ContentFactory;
import org.nakedobjects.plugins.dndviewer.viewer.content.OneToManyFieldImpl;
import org.nakedobjects.plugins.dndviewer.viewer.content.OneToOneFieldImpl;
import org.nakedobjects.plugins.dndviewer.viewer.content.RootCollection;
import org.nakedobjects.plugins.dndviewer.viewer.content.RootObject;
import org.nakedobjects.plugins.dndviewer.viewer.content.TextParseableFieldImpl;


public class DefaultContentFactory implements ContentFactory {

    public Content createRootContent(final NakedObject object) {
        Assert.assertNotNull(object);
        final NakedObjectSpecification objectSpec = object.getSpecification();
        if (objectSpec.isCollection()) {
            return new RootCollection(object);
        }
        if (objectSpec.isObject()) {
            return new RootObject(object);
        } 
    
        throw new IllegalArgumentException("Must be an object or collection: " + object);
    }

    public Content createFieldContent(final NakedObjectAssociation field, final NakedObject object) {
        Content content;
        NakedObject association = field.get(object);
        if (field instanceof OneToManyAssociation) {
            content = new OneToManyFieldImpl(object, association, (OneToManyAssociation) field);
        } else if (field instanceof OneToOneAssociation) {
            final NakedObjectSpecification fieldSpecification = field.getSpecification();
            if (fieldSpecification.isParseable()) {
                content = new TextParseableFieldImpl(object, association, (OneToOneAssociation) field);
            } else {
                content = new OneToOneFieldImpl(object, association, (OneToOneAssociation) field);
            }
        } else {
            throw new NakedObjectException();
        }

        return content;
    }

}
// Copyright (c) Naked Objects Group Ltd.
