package org.nakedobjects.plugins.dndviewer.viewer.action;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;


public class CloseWindowControl extends WindowControl {

    public CloseWindowControl(final View target) {
        super(new CloseViewOption(), target);
    }

    @Override
    public void draw(final Canvas canvas) {
        final int x = 0;
        final int y = 0;

        canvas.drawRectangle(x + 1, y + 1, WIDTH - 1, HEIGHT - 1, Toolkit.getColor("white"));
        canvas.drawRectangle(x, y, WIDTH - 1, HEIGHT - 1, Toolkit.getColor("secondary1"));
        final Color crossColor = Toolkit.getColor("black");
        canvas.drawLine(x + 4, y + 3, x + 10, y + 9, crossColor);
        canvas.drawLine(x + 5, y + 3, x + 11, y + 9, crossColor);
        canvas.drawLine(x + 10, y + 3, x + 4, y + 9, crossColor);
        canvas.drawLine(x + 11, y + 3, x + 5, y + 9, crossColor);
    }
}
// Copyright (c) Naked Objects Group Ltd.
