package org.nakedobjects.plugins.dndviewer.viewer.action;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;


public class IconizeWindowControl extends WindowControl {

    public IconizeWindowControl(final View target) {
        super(new IconizeViewOption(), target);
    }

    @Override
    public void draw(final Canvas canvas) {
        final int x = 0;
        final int y = 0;

        canvas.drawRectangle(x + 1, y + 1, WIDTH - 1, HEIGHT - 1, Toolkit.getColor("white"));
        canvas.drawRectangle(x, y, WIDTH - 1, HEIGHT - 1, Toolkit.getColor("secondary1"));
        canvas.drawLine(x + 3, y + 8, x + 8, y + 8, Toolkit.getColor("black"));
        canvas.drawLine(x + 3, y + 9, x + 8, y + 9, Toolkit.getColor("black"));
    }
}
// Copyright (c) Naked Objects Group Ltd.
