package org.nakedobjects.plugins.dndviewer.viewer.action;

import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;


public class ResizeWindowControl extends WindowControl {

    public ResizeWindowControl(final View target) {
        super(new UserAction() {

            public Consent disabled(final View view) {
                return Veto.DEFAULT;
            }

            public void execute(final Workspace workspace, final View view, final Location at) {}

            public String getDescription(final View view) {
                return "";
            }

            public String getHelp(final View view) {
                return "";
            }

            public NakedObjectActionType getType() {
                return USER;
            }

            public String getName(final View view) {
                return "Resize";
            }
        }, target);

    }

    @Override
    public void draw(final Canvas canvas) {
        final int x = 0;
        final int y = 0;

        canvas.drawRectangle(x + 1, y + 1, WIDTH - 1, HEIGHT - 1, Toolkit.getColor("white"));
        canvas.drawRectangle(x, y, WIDTH - 1, HEIGHT - 1, Toolkit.getColor("secondary1"));
        canvas.drawRectangle(x + 3, y + 2, 8, 8, Toolkit.getColor("secondary2"));
        canvas.drawLine(x + 3, y + 3, x + 10, y + 3, Toolkit.getColor("secondary2"));
    }
}
// Copyright (c) Naked Objects Group Ltd.
