package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.ObjectView;


public class FallbackView extends ObjectView {

    public static class Specification implements ViewSpecification {
        public boolean canDisplay(final Content content, ViewRequirement requirement) {
            return true;
        }

        public View createView(final Content content, final ViewAxis axis) {
            return new FallbackView(content, this, axis);
        }

        public String getName() {
            return "Fallback";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }

    protected FallbackView(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }

    @Override
    public void draw(final Canvas canvas) {
        super.draw(canvas);

        final Size size = getSize();
        final int width = size.getWidth() - 1;
        final int height = size.getHeight() - 1;
        canvas.drawSolidRectangle(0, 0, width, height, Toolkit.getColor("secondary3"));
        canvas.drawSolidRectangle(0, 0, 10, height, Toolkit.getColor("secondary2"));
        canvas.drawLine(10, 0, 10, height - 2, Toolkit.getColor("black"));
        canvas.drawRectangle(0, 0, width, height, Toolkit.getColor("black"));
        canvas.drawText(getContent().title(), 14, getBaseline(), Toolkit.getColor("black"), Toolkit.getText("normal"));
    }

    @Override
    public int getBaseline() {
        return 14;
    }

    @Override
    public Size getMaximumSize() {
        return new Size(150, 20);
    }

    @Override
    public ViewAreaType viewAreaType(final Location mouseLocation) {
        return mouseLocation.getX() <= 10 ? ViewAreaType.VIEW : ViewAreaType.CONTENT;
    }
}
// Copyright (c) Naked Objects Group Ltd.
