package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.border.ObjectBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.Icon;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.ObjectTitleText;


public abstract class IconSpecification implements ViewSpecification {
    private final boolean isSubView;
    private final boolean isReplaceable;

    public IconSpecification() {
        this(true, true);
    }

    IconSpecification(final boolean isSubView, final boolean isReplaceable) {
        this.isSubView = isSubView;
        this.isReplaceable = isReplaceable;
    }

    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        return requirement.isClosed() && content.isObject() && content.getNaked() != null;
    }
    
    public View createView(final Content content, final ViewAxis axis) {
        final Text style = Toolkit.getText("normal");
        final Icon icon = new Icon(content, this, axis);
        icon.setTitle(new ObjectTitleText(icon, style));
        icon.setSelectedIcon(new IconGraphic(icon, style));
        return new ObjectBorder(new IconOpenAction(icon));
    }

    public String getName() {
        return "Icon";
    }

    public boolean isSubView() {
        return isSubView;
    }

    public boolean isReplaceable() {
        return isReplaceable;
    }

    public View decorateSubview(final View subview) {
        return subview;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isAligned() {
        return false;
    }
}
// Copyright (c) Naked Objects Group Ltd.
