package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.nakedobjects.metamodel.facets.value.PasswordValueFacet;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractFieldSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.PasswordField;


public class PasswordFieldSpecification extends AbstractFieldSpecification {
    @Override
    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        return content.isTextParseable() && content.getSpecification().getFacet(PasswordValueFacet.class) != null;
    }

    public View createView(final Content content, final ViewAxis axis) {
        return new PasswordField(content, this, axis);
    }

    public String getName() {
        return "Password Field";
    }

    @Override
    public boolean isAligned() {
        return true;
    }
}
// Copyright (c) Naked Objects Group Ltd.
