package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewDrag;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.WindowControl;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Offset;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;


public abstract class AbstractWindowBorder extends AbstractBorder {
    protected BorderDrawing borderRender = new SwingStyleWindowBorder();
    //protected BorderDrawing borderRender = new SimpleStyleWindowBorder();
    protected WindowControl controls[];

    public AbstractWindowBorder(final View enclosedView) {
        super(enclosedView);
           left = borderRender.getLeft();
            right = borderRender.getRight();
            top = borderRender.getTop();
            bottom =borderRender.getBottom();
    }

    @Override
    public void debugDetails(final DebugString debug) {
        borderRender.debugDetails(debug);
        super.debugDetails(debug);
    }

    @Override
    public Drag dragStart(final DragStart drag) {
        if (overBorder(drag.getLocation())) {
            final Location location = drag.getLocation();
            final View dragOverlay = Toolkit.getViewFactory().createDragViewOutline(getView());
            return new ViewDrag(this, new Offset(location.getX(), location.getY()), dragOverlay);
        } else {
            return super.dragStart(drag);
        }
    }

    protected void setControls(final WindowControl[] controls) {
        this.controls = controls;
    }

    @Override
    public void setSize(final Size size) {
        super.setSize(size);
        layoutControls(size);
    }

    @Override
    public void setBounds(final Bounds bounds) {
        super.setBounds(bounds);
        layoutControls(bounds.getSize());
    }

    private void layoutControls(final Size size) {
        borderRender.layoutControls(size, controls);
    }

    @Override
    public void draw(final Canvas canvas) {
        // blank background
        final Bounds bounds = getBounds();
        canvas.drawSolidRectangle(3, 3, bounds.getWidth() - 6, bounds.getHeight() - 6, Toolkit.getColor("background.window."
                + getSpecification().getName()));

        final boolean hasFocus = containsFocus();
        final ViewState state = getState();
        borderRender.draw(canvas, getSize(), hasFocus, state, controls, title());

        // controls
        for (int i = 0; controls != null && i < controls.length; i++) {
            final Canvas controlCanvas = canvas.createSubcanvas(controls[i].getBounds());
            controls[i].draw(controlCanvas);
        }
        
        super.draw(canvas);
    }

    protected abstract String title();

    @Override
    public Size getRequiredSize(final Size maximumSize) {
        final Size size = super.getRequiredSize(maximumSize);
        borderRender.getRequiredSize(size, title(), controls);
        return size;
    }

    @Override
    public void secondClick(final Click click) {
        final View button = overControl(click.getLocation());
        if (button == null) {
            super.secondClick(click);
        }
    }

    @Override
    public void thirdClick(final Click click) {
        final View button = overControl(click.getLocation());
        if (button == null) {
            super.thirdClick(click);
        }
    }

    @Override
    public void firstClick(final Click click) {
        final View button = overControl(click.getLocation());
        if (button == null) {
            if (overBorder(click.getLocation())) {
                final Workspace workspace = getWorkspace();
                if (workspace != null) {
                    if (click.button2()) {
                        workspace.lower(getView());
                    } else if (click.button1()) {
                        workspace.raise(getView());
                    }
                }
            } else {
                super.firstClick(click);
            }

        } else {
            button.firstClick(click);
        }

    }

    private View overControl(final Location location) {
        for (int i = 0; i < controls.length; i++) {
            final WindowControl control = controls[i];
            if (control.getBounds().contains(location)) {
                return control;
            }
        }
        return null;
    }

}
// Copyright (c) Naked Objects Group Ltd.
