package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.FieldContent;
import org.nakedobjects.plugins.dndviewer.LabelAxis;
import org.nakedobjects.plugins.dndviewer.ParameterContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;


public class LabelBorder extends AbstractBorder {

    public static View createFieldLabelBorder(final View wrappedView) {
        final FieldContent fieldContent = (FieldContent) wrappedView.getContent();
        return createLabelBorder(fieldContent.getFieldName(), fieldContent.isMandatory(), wrappedView);
    }

    public static View createLabelBorder(final String name, final boolean mandatory, final View wrappedView) {
        final Text style = mandatory ? Toolkit.getText("mandatory-label") : Toolkit.getText("label");
        return new LabelBorder(name, style, wrappedView);
    }

    public static View createValueParameterLabelBorder(final View wrappedView) {
        final ParameterContent fieldContent = (ParameterContent) wrappedView.getContent();
        return createLabelBorder(fieldContent.getParameterName(), fieldContent.isRequired(), wrappedView);
    }

    protected static final Color DEFAULT_COLOR = Toolkit.getColor("primary1");
    private final String label;
    private final Text style;

    public LabelBorder(final String label, final View wrappedView) {
        this(label, Toolkit.getText("label"), wrappedView);
    }

    public LabelBorder(final String label, final Text style, final View wrappedView) {
        super(wrappedView);
        this.label = label + ":";
        this.style = style;

        final int width = HPADDING + style.stringWidth(this.label) + HPADDING;
        if (getViewAxis() == null) {
            left = width;
        } else {
            ((LabelAxis) getViewAxis()).accommodateWidth(width);
        }
    }

    @Override
    protected int getLeft() {
        if (getViewAxis() == null) {
            return left;
        } else {
            return ((LabelAxis) getViewAxis()).getWidth();
        }
    }

    @Override
    public void debugDetails(final DebugString debug) {
        super.debugDetails(debug);
        debug.appendln("label", "'" + label + "'");
    }

    @Override
    public void draw(final Canvas canvas) {
        final Color color = textColor();
        canvas.drawText(label, HPADDING, wrappedView.getBaseline(), color, style);
        super.draw(canvas);
    }

    protected Color textColor() {
        return DEFAULT_COLOR;
    }

    @Override
    public String toString() {
        return wrappedView.toString() + "/" + ToString.name(this);
    }
}
// Copyright (c) Naked Objects Group Ltd.
