package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;

public class SelectedBorder extends AbstractBorder {

    public SelectedBorder(View view) {
        super(view);
    }
    
    public void firstClick(Click click) {
        ((SelectableViewAxis) getView().getViewAxis()).selected(getView());
        super.firstClick(click);
    }
    
    public void draw(Canvas canvas) {
        if (((SelectableViewAxis) getView().getViewAxis()).isSelected(getView())){
            Size size = getSize();
            canvas.drawSolidRectangle(left, right, size.getWidth() - left - right, size.getHeight() - top - bottom, Toolkit.getColor("primary3"));
        }
        super.draw(canvas);
    }

}


// Copyright (c) Naked Objects Group Ltd.
