package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.NakedObjectList;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.lang.ArrayUtils;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.viewer.action.DisposeObjectOption;


public class OptionFactory {

    public static void addCreateOptions(final NakedObjectSpecification specification, final UserActionSet options) {
        NakedObjectAction[] actions;
        // TODO do the same as addObjectMenuOptions and collect together all the actions for all the types
        actions = specification.getServiceActionsFor(NakedObjectActionConstants.USER);
        menuOptions(actions, null, options);
    }

    public static void addObjectMenuOptions(final NakedObject object, final UserActionSet options) {
        if (object != null) {
            final NakedObjectAction[] actions1 = object.getSpecification().getObjectActions(NakedObjectActionConstants.USER);
            final NakedObjectAction[] actions2 = object.getSpecification().getObjectActions(
                    NakedObjectActionConstants.EXPLORATION);
            final NakedObjectAction[] actions3 = object.getSpecification().getObjectActions(NakedObjectActionConstants.DEBUG);
            final NakedObjectAction[] actions = ArrayUtils.combine(actions1, actions2, actions3);
            menuOptions(actions, object, options);

            final Oid oid = object.getOid();
            final boolean isPersistent = oid != null && !oid.isTransient();
            if (!(object.getSpecification().isService()) && !(object.getObject() instanceof NakedObjectList)
                    && isPersistent) {
                options.add(new DisposeObjectOption());
            }
        }
    }

    private static void menuOptions(final NakedObjectAction[] actions, final NakedObject target, final UserActionSet menuOptionSet) {
        for (int i = 0; i < actions.length; i++) {
            UserAction option = null;
            if (actions[i].getActions().length > 0) {
                option = new UserActionSet(actions[i].getName(), menuOptionSet);
                menuOptions(actions[i].getActions(), target, (UserActionSet) option);

            } else {
                final int noOfParameters = actions[i].getParameterCount();
                if (noOfParameters == 0) {
                    option = ImmediateObjectOption.createOption(actions[i], target);
                } else if (actions[i].isContributed() && noOfParameters == 1 && target != null
                        && target.getSpecification().isOfType(actions[i].getParameters()[0].getSpecification())) {
                    option = ImmediateObjectOption.createServiceOption(actions[i], target);
                } else {
                    option = DialoggedObjectOption.createOption(actions[i], target);
                }
            }
            if (option != null) {
                menuOptionSet.add(option);
            }
        }
    }
}

// Copyright (c) Naked Objects Group Ltd.
