package org.nakedobjects.plugins.dndviewer.viewer.debug;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;


public class DebugBorder extends AbstractBorder {
    public DebugBorder(final View wrappedView) {
        super(wrappedView);

        bottom = Toolkit.getText("debug").getTextHeight();
    }

    @Override
    protected void debugDetails(final DebugString debug) {
        debug.append("DebugBorder");
    }

    @Override
    public void draw(final Canvas canvas) {
        final String debug = getView() + " " + getState();
        final int baseline = wrappedView.getSize().getHeight() + Toolkit.getText("debug").getAscent();
        final Color color = Toolkit.getColor("debug.baseline");
        canvas.drawText(debug, 0, baseline, color, Toolkit.getText("debug"));

        super.draw(canvas);
    }

    @Override
    public String toString() {
        return wrappedView.toString() + "/DebugBorder";
    }

    @Override
    public void firstClick(final Click click) {
        new DebugOption().execute(getWorkspace(), getView(), click.getLocation());
    }
}
// Copyright (c) Naked Objects Group Ltd.
