package org.nakedobjects.plugins.dndviewer.viewer.list;

import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.SubviewSpec;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.builder.CollectionElementBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.StackLayout;


public abstract class AbstractListSpecification extends AbstractCompositeViewSpecification implements SubviewSpec {

    public AbstractListSpecification() {
        builder = new StackLayout(new CollectionElementBuilder(this));
    }

    public String getName() {
        return "List";
    }

    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        return content.isCollection() && requirement.is(ViewRequirement.OPEN);
    }
}
// Copyright (c) Naked Objects Group Ltd.
