package org.nakedobjects.plugins.dndviewer.viewer.list;

import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.border.ExpandableViewBorder;


public class ExpandableListSpecification extends AbstractListSpecification {

    public String getName() {
        return "Expanding List";
    }

    @Override
    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        return content.isCollection() && requirement.is(ViewRequirement.CLOSED);
    }
    
    public View createSubview(final Content content, final ViewAxis axis, int fieldNumber) {
        ViewRequirement requirement = new ViewRequirement(content, ViewRequirement.CLOSED);
       return Toolkit.getViewFactory().createView(requirement);
    }

    @Override
    public View decorateView(View subview) {
        return new ExpandableViewBorder(subview);
    }
  
}
// Copyright (c) Naked Objects Group Ltd.
