package org.nakedobjects.plugins.dndviewer.viewer.list;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

class HistogramBar extends AbstractView {

    protected HistogramBar(Content content, ViewAxis axis) {
        super(content, axis);
    }
    
    public void draw(Canvas canvas) {
        super.draw(canvas);
        int y = 0; //   getLocation().getY();
        int height = getSize().getHeight() - 8;
        canvas.drawText(getContent().title(), 0, height / 2 + Toolkit.getText("label").getAscent() / 2, Toolkit.getColor("primary1"), Toolkit.getText("label"));
        double length = 400 * Math.random();
        canvas.drawSolidRectangle(60, y, (int) length, height, Toolkit.getColor("primary2"));
        canvas.drawRectangle(60, y, (int) length, height, Toolkit.getColor("black"));
    }

}


// Copyright (c) Naked Objects Group Ltd.
