package org.nakedobjects.plugins.dndviewer.viewer.lookup;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.dndviewer.CompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.SubviewSpec;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.CompositeViewBuilder;


public class DropDownListBuilder extends AbstractViewBuilder {
    private final SubviewSpec subviewSpecification;

    public DropDownListBuilder(final SubviewSpec subviewSpecification) {
        this.subviewSpecification = subviewSpecification;
    }

    @Override
    public void build(final View view) {
        final Content content = view.getContent();
        final NakedObject[] options = content.getOptions();

        // TODO sort list

        for (int i = 0; i < options.length; i++) {
            final Content subContent = new OptionContent(options[i]);
            final View subview = subviewSpecification.createSubview(subContent, view.getViewAxis(), i);
            view.addView(subview);
        }
    }

    public View createCompositeView(final Content content, final CompositeViewSpecification specification, final ViewAxis axis) {
        final CompositeViewBuilder view = new CompositeViewBuilder(content, specification, axis);
        view.setCanDragView(false);
        return view;
    }

}

// Copyright (c) Naked Objects Group Ltd.
