package org.nakedobjects.plugins.dndviewer.viewer.lookup;

import org.nakedobjects.metamodel.commons.exceptions.UnexpectedCallException;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.SubviewSpec;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.border.BackgroundBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.DisposeOverlay;
import org.nakedobjects.plugins.dndviewer.viewer.border.LineBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.ScrollBorder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.builder.StackLayout;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.Icon;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.ObjectTitleText;


class DropDownObjectOverlaySpecification extends AbstractCompositeViewSpecification implements SubviewSpec {
    public DropDownObjectOverlaySpecification() {
        builder = new StackLayout(new DropDownListBuilder(this), true);
    }

    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        throw new UnexpectedCallException();
    }

    // TODO make this class abstract and create subclass (DropDownObjectObjectOverlaySepecification) with this
    // method
    public View createSubview(final Content content, final ViewAxis lookupAxis, int fieldNumber) {
        final Icon icon = new Icon(content, this, lookupAxis);
        final Text style = Toolkit.getText("normal");
        icon.setTitle(new ObjectTitleText(icon, style));
        icon.setSelectedIcon(new IconGraphic(icon, style));
        return new DropDownSelection(icon);
    }
    
    @Override
    protected View decorateView(View view) {
        View list = new DropDownFocusBorder(view);
        return new DisposeOverlay(new BackgroundBorder(new LineBorder(new ScrollBorder(list))));
    }

    public String getName() {
        return "Object Drop Down Overlay";
    }
}

// Copyright (c) Naked Objects Group Ltd.
