package org.nakedobjects.plugins.dndviewer.viewer.lookup;

import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.OneToOneField;
import org.nakedobjects.plugins.dndviewer.ParameterContent;
import org.nakedobjects.plugins.dndviewer.View;


public class OpenObjectDropDownBorder extends OpenDropDownBorder {
    private static final DropDownObjectOverlaySpecification spec = new DropDownObjectOverlaySpecification();

    public OpenObjectDropDownBorder(final View wrappedView) {
        super(wrappedView);
    }

    @Override
    protected View createOverlay() {
        final ObjectContent content = (ObjectContent) getContent();
        return spec.createView(getContent(), new ObjectDropDownAxis(content, getView()));
    }

    @Override
    protected boolean isAvailable() {
        final Content content = getContent();
        if (content instanceof OneToOneField) {
            final OneToOneField oneToOneField = ((OneToOneField) content);
            return oneToOneField.isEditable().isAllowed();
        } else if (content instanceof ParameterContent) {
            return true;
        } else {
            return false;
        }

    }
}
// Copyright (c) Naked Objects Group Ltd.
