package org.nakedobjects.plugins.dndviewer.viewer.tree;

import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.view.form.WindowFormSpecification;

public class FormWithDetailSpecification implements ViewSpecification {

    public boolean canDisplay(Content content, ViewRequirement requirement) {
        return content.isObject() && requirement.is(ViewRequirement.OPEN);
    }

    public View createView(Content content, ViewAxis axis) {
        return new MasterDetailPanel(content, this, null, new WindowFormSpecification());
    }
    
    public String getName() {
        return "Form and details";
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return true;
    }

    public boolean isSubView() {
        return false;
    }

}


// Copyright (c) Naked Objects Group Ltd.
