package org.nakedobjects.plugins.dndviewer.viewer.view.calendar;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;


public class NamedCalendarBorderTab implements CalendarBorderTab {
    final Text style = Toolkit.getText("normal");
    final Color color = Toolkit.getColor("black");
    private final String name;
    private final CalendarDisplay calendarDisplay;

    public NamedCalendarBorderTab(final String name, final CalendarDisplay calendarDisplay) {
        this.name = name;
        this.calendarDisplay = calendarDisplay;
    }

    public boolean select(final Click click, final CalendarTemplate calendar) {
        calendar.setCalendarDisplay(calendarDisplay);
        return true;
    }

    public void draw(final Canvas tabcanvas, final int width) {
        tabcanvas.drawText(name, 5, 15, color, style);
    }
}

// Copyright (c) Naked Objects Group Ltd.
