package org.nakedobjects.plugins.dndviewer.viewer.view.form;

import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.border.ExpandableViewBorder;


public class WindowExpandableFormSpecification extends WindowFormSpecification {

    @Override
    public View decorateSubview(View subview) {
        View view = super.decorateSubview(subview);
        if (subview.getContent().isObject() || subview.getContent().isCollection()) {
            return new ExpandableViewBorder(view);
        } else {
            return view;
        }
    }

    protected int collectionRequirement() {
        return ViewRequirement.CLOSED;
    }

    public String getName() {
        return "Expanding Form";
    }
}
// Copyright (c) Naked Objects Group Ltd.
